/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.chain;

import com.blockchain.scanning.biz.scan.ScanService;
import com.blockchain.scanning.biz.thread.EventQueue;
import com.blockchain.scanning.biz.thread.RetryStrategyQueue;
import com.blockchain.scanning.chain.model.TransactionModel;
import com.blockchain.scanning.commons.config.BlockChainConfig;
import com.blockchain.scanning.commons.enums.BlockEnums;
import com.blockchain.scanning.commons.enums.ChainType;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainScanner {
    private Logger logger = LoggerFactory.getLogger(ScanService.class);
    protected BlockChainConfig blockChainConfig;
    protected EventQueue eventQueue;
    protected RetryStrategyQueue retryStrategyQueue;
    private AtomicInteger atomicInteger;

    public ChainType getChainType() {
        return this.blockChainConfig.getChainType();
    }

    public void scanStart() {
        String logBeginBlockNumber = this.blockChainConfig.getBeginBlockNumber().compareTo(BlockEnums.LAST_BLOCK_NUMBER.getValue()) == 0 ? BlockEnums.LAST_BLOCK_NUMBER.getText() : this.blockChainConfig.getBeginBlockNumber().toString();
        this.logger.info("start scanning, chainType: {}, beginBlockNumber: {}", (Object)this.blockChainConfig.getChainType().toString(), (Object)logBeginBlockNumber);
        try {
            this.scan(this.blockChainConfig.getBeginBlockNumber());
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while scanning, chainType: {}, beginBlockNumber: {}", new Object[]{this.blockChainConfig.getChainType().toString(), logBeginBlockNumber, e});
        }
    }

    public void init(BlockChainConfig blockChainConfig, EventQueue eventQueue, RetryStrategyQueue retryStrategyQueue) {
        if (this.blockChainConfig == null) {
            this.blockChainConfig = blockChainConfig;
        }
        if (this.eventQueue == null) {
            this.eventQueue = eventQueue;
        }
        if (this.retryStrategyQueue == null) {
            this.retryStrategyQueue = retryStrategyQueue;
        }
        this.atomicInteger = new AtomicInteger(0);
    }

    protected void addRetry(BigInteger blockNumber) {
        if (this.retryStrategyQueue != null) {
            this.retryStrategyQueue.add(blockNumber);
        }
    }

    protected int getNextIndex(int maxValue) {
        int index = this.atomicInteger.get();
        if (index < maxValue - 1) {
            this.atomicInteger.incrementAndGet();
        } else {
            this.atomicInteger.set(0);
        }
        return index;
    }

    public abstract void scan(BigInteger var1);

    public abstract void call(TransactionModel var1);
}

