/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.biz.thread;

import com.blockchain.scanning.biz.thread.RetryStrategyQueue;
import com.blockchain.scanning.chain.RetryStrategy;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryStrategyConsumer
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RetryStrategyConsumer.class);
    private RetryStrategyQueue retryStrategyQueue;
    private RetryStrategy retryStrategy;
    private boolean shutdown;

    public RetryStrategyConsumer(RetryStrategyQueue retryStrategyQueue, RetryStrategy retryStrategy) {
        this.retryStrategyQueue = retryStrategyQueue;
        this.retryStrategy = retryStrategy;
        this.shutdown = false;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public void run() {
        while (true) {
            BigInteger blockNumber = null;
            try {
                blockNumber = this.retryStrategyQueue.getLinkedBlockingQueue().poll(2000L, TimeUnit.MILLISECONDS);
                if (blockNumber == null) {
                    if (!this.shutdown) continue;
                    return;
                }
                this.logger.info("Start rescanning block height:[{}]", (Object)blockNumber);
                this.retryStrategy.retry(blockNumber);
                continue;
            }
            catch (Exception e) {
                if (blockNumber != null) {
                    this.logger.error("Rescan block with exception, block height:[{}]", (Object)blockNumber, (Object)e);
                    continue;
                }
                this.logger.error("Rescan block with exception", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

