/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.biz.thread;

import com.blockchain.scanning.biz.thread.EventQueue;
import com.blockchain.scanning.biz.thread.model.EventModel;
import com.blockchain.scanning.chain.ChainScanner;
import com.blockchain.scanning.chain.model.TransactionModel;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConsumer
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(EventConsumer.class);
    private ChainScanner chainScanner;
    private EventQueue eventQueue;
    private boolean shutdown;

    public EventConsumer(ChainScanner chainScanner, EventQueue eventQueue) {
        this.chainScanner = chainScanner;
        this.eventQueue = eventQueue;
        this.shutdown = false;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public void run() {
        block2: while (true) {
            EventModel eventModel = null;
            try {
                eventModel = this.eventQueue.getLinkedBlockingQueue().poll(2000L, TimeUnit.MILLISECONDS);
                if (eventModel == null) {
                    if (!this.shutdown) continue;
                    return;
                }
                this.logger.info("[{}], Transaction records with block height [{}] are being processed", (Object)this.chainScanner.getChainType().toString(), (Object)eventModel.getCurrentBlockHeight());
                List<TransactionModel> transactionResultList = eventModel.getTransactionModels();
                Iterator<TransactionModel> iterator = transactionResultList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    TransactionModel transactionModel = iterator.next();
                    this.chainScanner.call(transactionModel);
                }
            }
            catch (Exception e) {
                if (eventModel == null) {
                    this.logger.error("[{}], Exception in processing transaction record", (Object)this.chainScanner.getChainType().toString(), (Object)e);
                    continue;
                }
                this.logger.error("[{}], Exception in processing transaction record, block height: [{}]", new Object[]{this.chainScanner.getChainType().toString(), eventModel.getCurrentBlockHeight(), e});
                continue;
            }
            break;
        }
    }
}

