/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning.biz.scan;

import com.blockchain.scanning.biz.thread.EventConsumer;
import com.blockchain.scanning.biz.thread.EventQueue;
import com.blockchain.scanning.biz.thread.EventThreadPool;
import com.blockchain.scanning.biz.thread.RetryStrategyConsumer;
import com.blockchain.scanning.biz.thread.RetryStrategyQueue;
import com.blockchain.scanning.chain.ChainScanner;
import com.blockchain.scanning.chain.RetryStrategy;
import com.blockchain.scanning.chain.factory.ChainScannerFactory;
import com.blockchain.scanning.commons.config.BlockChainConfig;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class ScanService {
    private ChainScanner chainScanner;
    private RetryStrategy retryStrategy;
    private BlockChainConfig blockChainConfig;
    private EventQueue eventQueue;
    private Timer timer;
    private EventConsumer eventConsumer;
    private RetryStrategyConsumer retryStrategyConsumer;
    protected RetryStrategyQueue retryStrategyQueue;

    public Timer getTimer() {
        return this.timer;
    }

    public EventConsumer getEventConsumer() {
        return this.eventConsumer;
    }

    public RetryStrategyConsumer getRetryStrategyConsumer() {
        return this.retryStrategyConsumer;
    }

    public void init(BlockChainConfig blockChainConfig) throws Exception {
        this.blockChainConfig = blockChainConfig;
        this.chainScanner = ChainScannerFactory.getChainScanner(this.blockChainConfig.getChainType());
        this.retryStrategy = this.blockChainConfig.getRetryStrategy();
        this.eventQueue = new EventQueue();
        if (this.retryStrategy != null) {
            this.retryStrategyQueue = new RetryStrategyQueue();
        }
        this.chainScanner.init(blockChainConfig, this.eventQueue, this.retryStrategyQueue);
        this.eventConsumer = new EventConsumer(this.chainScanner, this.eventQueue);
        EventThreadPool.submit(this.eventConsumer);
        if (this.retryStrategy != null) {
            this.retryStrategyConsumer = new RetryStrategyConsumer(this.retryStrategyQueue, this.retryStrategy);
            EventThreadPool.submit(this.retryStrategyConsumer);
        }
    }

    public void start() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ScanService.this.chainScanner.scanStart();
            }
        }, new Date(), this.blockChainConfig.getScanPeriod());
    }
}

