/*
 * Decompiled with CFR 0.152.
 */
package com.blockchain.scanning;

import com.blockchain.scanning.biz.scan.ScanService;
import com.blockchain.scanning.biz.thread.EventConsumer;
import com.blockchain.scanning.biz.thread.EventThreadPool;
import com.blockchain.scanning.biz.thread.RetryStrategyConsumer;
import com.blockchain.scanning.chain.RetryStrategy;
import com.blockchain.scanning.commons.config.BlockChainConfig;
import com.blockchain.scanning.commons.config.rpcinit.RpcInit;
import com.blockchain.scanning.commons.config.rpcinit.impl.EthRpcInit;
import com.blockchain.scanning.commons.config.rpcinit.impl.SolRpcInit;
import com.blockchain.scanning.commons.config.rpcinit.impl.TronRpcInit;
import com.blockchain.scanning.commons.enums.ChainType;
import com.blockchain.scanning.monitor.EthMonitorEvent;
import com.blockchain.scanning.monitor.TronMonitorEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;

public class MagicianBlockchainScan {
    private ScanService scanService = new ScanService();
    private BlockChainConfig blockChainConfig = new BlockChainConfig();
    private boolean rpcUrlExist = false;
    private static List<MagicianBlockchainScan> magicianBlockchainScans;

    private MagicianBlockchainScan() {
        magicianBlockchainScans = new ArrayList<MagicianBlockchainScan>();
    }

    public static MagicianBlockchainScan create() {
        return new MagicianBlockchainScan();
    }

    public MagicianBlockchainScan setRpcUrl(RpcInit rpcInit) {
        if (rpcInit instanceof EthRpcInit) {
            this.blockChainConfig.setChainType(ChainType.ETH);
            this.blockChainConfig.setHttpService(rpcInit.getBlockChainConfig().getHttpService());
        } else if (rpcInit instanceof SolRpcInit) {
            this.blockChainConfig.setChainType(ChainType.SOL);
        } else if (rpcInit instanceof TronRpcInit) {
            this.blockChainConfig.setChainType(ChainType.TRON);
            this.blockChainConfig.setTronRpcUrls(rpcInit.getBlockChainConfig().getTronRpcUrls());
        }
        this.rpcUrlExist = true;
        return this;
    }

    public MagicianBlockchainScan setRetryStrategy(RetryStrategy retryStrategy) {
        this.blockChainConfig.setRetryStrategy(retryStrategy);
        return this;
    }

    public MagicianBlockchainScan setScanPeriod(long scanPeriod) {
        this.blockChainConfig.setScanPeriod(scanPeriod);
        return this;
    }

    public MagicianBlockchainScan setBeginBlockNumber(BigInteger beginBlockNumber) {
        this.blockChainConfig.setBeginBlockNumber(beginBlockNumber);
        return this;
    }

    public MagicianBlockchainScan addEthMonitorEvent(EthMonitorEvent ethMonitorEvent) {
        this.blockChainConfig.getEventConfig().addEthMonitorEvent(ethMonitorEvent);
        return this;
    }

    public MagicianBlockchainScan addTronMonitorEvent(TronMonitorEvent tronMonitorEvent) {
        this.blockChainConfig.getEventConfig().addTronMonitorEvents(tronMonitorEvent);
        return this;
    }

    public void start() throws Exception {
        if (!this.rpcUrlExist) {
            throw new Exception("rpcUrl cannot be empty");
        }
        if (this.blockChainConfig.getChainType() == null) {
            throw new Exception("ChainType cannot be empty");
        }
        if (this.blockChainConfig.getScanPeriod() < 300L) {
            throw new Exception("scanPeriod must be greater than 300");
        }
        if (this.blockChainConfig.getChainType().equals((Object)ChainType.ETH) && (this.blockChainConfig.getEventConfig() == null || this.blockChainConfig.getEventConfig().getEthMonitorEvent() == null || this.blockChainConfig.getEventConfig().getEthMonitorEvent().size() < 1)) {
            throw new Exception("You need to set up at least one monitor event");
        }
        if (this.blockChainConfig.getChainType().equals((Object)ChainType.TRON) && (this.blockChainConfig.getEventConfig() == null || this.blockChainConfig.getEventConfig().getTronMonitorEvents() == null || this.blockChainConfig.getEventConfig().getTronMonitorEvents().size() < 1)) {
            throw new Exception("You need to set up at least one monitor event");
        }
        this.scanService.init(this.blockChainConfig);
        this.scanService.start();
        magicianBlockchainScans.add(this);
    }

    public void shutdown() {
        RetryStrategyConsumer retryStrategyConsumer;
        EventConsumer eventConsumer;
        Timer timer = this.scanService.getTimer();
        if (timer != null) {
            timer.cancel();
        }
        if ((eventConsumer = this.scanService.getEventConsumer()) != null) {
            eventConsumer.setShutdown(true);
        }
        if ((retryStrategyConsumer = this.scanService.getRetryStrategyConsumer()) != null) {
            retryStrategyConsumer.setShutdown(true);
        }
    }

    public static void shutdownAll() {
        for (MagicianBlockchainScan magicianBlockchainScan : magicianBlockchainScans) {
            magicianBlockchainScan.shutdown();
        }
        EventThreadPool.shutdown();
    }
}

