/*
 * Decompiled with CFR 0.152.
 */
package com.seanyinx.github.unit.scaffolding;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;

public class Poller {
    private final int timeoutMillis;
    private final int pollingIntervalMillis;

    public Poller(int timeoutMillis, int pollingIntervalMillis) {
        this.timeoutMillis = timeoutMillis;
        this.pollingIntervalMillis = pollingIntervalMillis;
    }

    public void assertEventually(Predicate predicate) {
        this.assertEventually(predicate, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEventually(Predicate predicate, String description) {
        long startTime = System.currentTimeMillis();
        try {
            while (this.notInterrupted() && this.notTimeout(startTime) && !predicate.isSatisfied()) {
                this.sleep();
            }
        }
        finally {
            MatcherAssert.assertThat((String)description, (Object)predicate.isSatisfied(), (Matcher)Is.is((Object)true));
        }
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.pollingIntervalMillis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private boolean notInterrupted() {
        return !Thread.currentThread().isInterrupted();
    }

    private boolean notTimeout(long startTime) {
        return System.currentTimeMillis() < startTime + (long)this.timeoutMillis;
    }

    public static interface Predicate {
        public boolean isSatisfied();
    }
}

