/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.audit.support;

import com.github.inspektr.audit.AuditActionContext;
import com.github.inspektr.audit.AuditTrailManager;

public abstract class AbstractStringAuditTrailManager
implements AuditTrailManager {
    private boolean useSingleLine = false;
    private String entrySeparator = ",";

    protected String getEntrySeparator() {
        return this.entrySeparator;
    }

    public void setEntrySeparator(String separator) {
        this.entrySeparator = separator;
    }

    public void setUseSingleLine(boolean useSingleLine) {
        this.useSingleLine = useSingleLine;
    }

    protected String toString(AuditActionContext auditActionContext) {
        if (this.useSingleLine) {
            return this.getSingleLineAuditString(auditActionContext);
        }
        return this.getMultiLineAuditString(auditActionContext);
    }

    protected String getMultiLineAuditString(AuditActionContext auditActionContext) {
        StringBuilder builder = new StringBuilder();
        builder.append("Audit trail record BEGIN\n");
        builder.append("=============================================================\n");
        builder.append("WHO: ");
        builder.append(auditActionContext.getPrincipal());
        builder.append("\n");
        builder.append("WHAT: ");
        builder.append(auditActionContext.getResourceOperatedUpon());
        builder.append("\n");
        builder.append("ACTION: ");
        builder.append(auditActionContext.getActionPerformed());
        builder.append("\n");
        builder.append("APPLICATION: ");
        builder.append(auditActionContext.getApplicationCode());
        builder.append("\n");
        builder.append("WHEN: ");
        builder.append(auditActionContext.getWhenActionWasPerformed());
        builder.append("\n");
        builder.append("CLIENT IP ADDRESS: ");
        builder.append(auditActionContext.getClientIpAddress());
        builder.append("\n");
        builder.append("SERVER IP ADDRESS: ");
        builder.append(auditActionContext.getServerIpAddress());
        builder.append("\n");
        builder.append("=============================================================");
        builder.append("\n\n");
        return builder.toString();
    }

    protected String getSingleLineAuditString(AuditActionContext auditActionContext) {
        StringBuilder builder = new StringBuilder();
        builder.append(auditActionContext.getWhenActionWasPerformed());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getApplicationCode());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getResourceOperatedUpon());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getActionPerformed());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getPrincipal());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getClientIpAddress());
        builder.append(this.getEntrySeparator());
        builder.append(auditActionContext.getServerIpAddress());
        return builder.toString();
    }
}

