/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.UpdateChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.ChainWrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public interface IService<T> {
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public boolean save(T entity) {
        return SqlHelper.retBool(this.getBaseMapper().insert(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean saveBatch(Collection<T> entityList) {
        return this.saveBatch(entityList, 1000);
    }

    public boolean saveBatch(Collection<T> var1, int var2);

    @Transactional(rollbackFor={Exception.class})
    default public boolean saveOrUpdateBatch(Collection<T> entityList) {
        return this.saveOrUpdateBatch(entityList, 1000);
    }

    public boolean saveOrUpdateBatch(Collection<T> var1, int var2);

    default public boolean removeById(Serializable id) {
        return SqlHelper.retBool(this.getBaseMapper().deleteById(id));
    }

    default public boolean removeById(Serializable id, boolean useFill) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5!");
    }

    default public boolean removeById(T entity) {
        return SqlHelper.retBool(this.getBaseMapper().deleteById(entity));
    }

    default public boolean removeByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return SqlHelper.retBool(this.getBaseMapper().deleteByMap(columnMap));
    }

    default public boolean remove(Wrapper<T> queryWrapper) {
        return SqlHelper.retBool(this.getBaseMapper().delete(queryWrapper));
    }

    default public boolean removeByIds(Collection<?> list) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        return SqlHelper.retBool(this.getBaseMapper().deleteBatchIds(list));
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean removeByIds(Collection<?> list, boolean useFill) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        if (useFill) {
            return this.removeBatchByIds(list, true);
        }
        return SqlHelper.retBool(this.getBaseMapper().deleteBatchIds(list));
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean removeBatchByIds(Collection<?> list) {
        return this.removeBatchByIds(list, 1000);
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean removeBatchByIds(Collection<?> list, boolean useFill) {
        return this.removeBatchByIds(list, 1000, useFill);
    }

    default public boolean removeBatchByIds(Collection<?> list, int batchSize) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5!");
    }

    default public boolean removeBatchByIds(Collection<?> list, int batchSize, boolean useFill) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5!");
    }

    default public boolean updateById(T entity) {
        return SqlHelper.retBool(this.getBaseMapper().updateById(entity));
    }

    default public boolean update(Wrapper<T> updateWrapper) {
        return this.update(null, updateWrapper);
    }

    default public boolean update(T entity, Wrapper<T> updateWrapper) {
        return SqlHelper.retBool(this.getBaseMapper().update(entity, updateWrapper));
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean updateBatchById(Collection<T> entityList) {
        return this.updateBatchById(entityList, 1000);
    }

    public boolean updateBatchById(Collection<T> var1, int var2);

    public boolean saveOrUpdate(T var1);

    default public T getById(Serializable id) {
        return (T)this.getBaseMapper().selectById(id);
    }

    default public List<T> listByIds(Collection<? extends Serializable> idList) {
        return this.getBaseMapper().selectBatchIds(idList);
    }

    default public List<T> listByMap(Map<String, Object> columnMap) {
        return this.getBaseMapper().selectByMap(columnMap);
    }

    default public T getOne(Wrapper<T> queryWrapper) {
        return this.getOne(queryWrapper, true);
    }

    public T getOne(Wrapper<T> var1, boolean var2);

    public Map<String, Object> getMap(Wrapper<T> var1);

    public <V> V getObj(Wrapper<T> var1, Function<? super Object, V> var2);

    default public long count() {
        return this.count((Wrapper<T>)Wrappers.emptyWrapper());
    }

    default public long count(Wrapper<T> queryWrapper) {
        return SqlHelper.retCount(this.getBaseMapper().selectCount(queryWrapper));
    }

    default public List<T> list(Wrapper<T> queryWrapper) {
        return this.getBaseMapper().selectList(queryWrapper);
    }

    default public List<T> list() {
        return this.list((Wrapper<T>)Wrappers.emptyWrapper());
    }

    default public <E extends IPage<T>> E page(E page, Wrapper<T> queryWrapper) {
        return (E)this.getBaseMapper().selectPage(page, queryWrapper);
    }

    default public <E extends IPage<T>> E page(E page) {
        return this.page(page, (Wrapper<T>)Wrappers.emptyWrapper());
    }

    default public List<Map<String, Object>> listMaps(Wrapper<T> queryWrapper) {
        return this.getBaseMapper().selectMaps(queryWrapper);
    }

    default public List<Map<String, Object>> listMaps() {
        return this.listMaps((Wrapper<T>)Wrappers.emptyWrapper());
    }

    default public List<Object> listObjs() {
        return this.listObjs(Function.identity());
    }

    default public <V> List<V> listObjs(Function<? super Object, V> mapper) {
        return this.listObjs((Wrapper<T>)Wrappers.emptyWrapper(), mapper);
    }

    default public List<Object> listObjs(Wrapper<T> queryWrapper) {
        return this.listObjs(queryWrapper, Function.identity());
    }

    default public <V> List<V> listObjs(Wrapper<T> queryWrapper, Function<? super Object, V> mapper) {
        return this.getBaseMapper().selectObjs(queryWrapper).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    default public <E extends IPage<Map<String, Object>>> E pageMaps(E page, Wrapper<T> queryWrapper) {
        return (E)this.getBaseMapper().selectMapsPage(page, queryWrapper);
    }

    default public <E extends IPage<Map<String, Object>>> E pageMaps(E page) {
        return this.pageMaps(page, (Wrapper<T>)Wrappers.emptyWrapper());
    }

    public BaseMapper<T> getBaseMapper();

    public Class<T> getEntityClass();

    default public QueryChainWrapper<T> query() {
        return ChainWrappers.queryChain(this.getBaseMapper());
    }

    default public LambdaQueryChainWrapper<T> lambdaQuery() {
        return ChainWrappers.lambdaQueryChain(this.getBaseMapper());
    }

    default public KtQueryChainWrapper<T> ktQuery() {
        return ChainWrappers.ktQueryChain(this.getBaseMapper(), this.getEntityClass());
    }

    default public KtUpdateChainWrapper<T> ktUpdate() {
        return ChainWrappers.ktUpdateChain(this.getBaseMapper(), this.getEntityClass());
    }

    default public UpdateChainWrapper<T> update() {
        return ChainWrappers.updateChain(this.getBaseMapper());
    }

    default public LambdaUpdateChainWrapper<T> lambdaUpdate() {
        return ChainWrappers.lambdaUpdateChain(this.getBaseMapper());
    }

    default public boolean saveOrUpdate(T entity, Wrapper<T> updateWrapper) {
        return this.update(entity, updateWrapper) || this.saveOrUpdate(entity);
    }
}

