/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.Interceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBrief;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBriefInterceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemPrinter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemScheduledPrinter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsItemScheduledIncrementPrinter
extends StatisticsItemScheduledPrinter {
    private String[] tpsItemNames;
    public static final int TPS_INITIAL_DELAY = 0;
    public static final int TPS_INTREVAL = 1000;
    public static final String SEPERATOR = "|";
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> lastItemSnapshots = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItemSampleBrief>> sampleBriefs = new ConcurrentHashMap();

    public StatisticsItemScheduledIncrementPrinter(String name, StatisticsItemPrinter printer, ScheduledExecutorService executor, StatisticsItemScheduledPrinter.InitialDelay initialDelay, long interval, String[] tpsItemNames, StatisticsItemScheduledPrinter.Enable enable) {
        super(name, printer, executor, initialDelay, interval, enable);
        this.tpsItemNames = tpsItemNames;
    }

    @Override
    public void schedule(final StatisticsItem item) {
        this.setItemSampleBrief(item.getStatKind(), item.getStatObject(), new StatisticsItemSampleBrief(item, this.tpsItemNames));
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!StatisticsItemScheduledIncrementPrinter.this.enabled()) {
                    return;
                }
                StatisticsItem snapshot = item.snapshot();
                StatisticsItem lastSnapshot = StatisticsItemScheduledIncrementPrinter.this.getItemSnapshot(StatisticsItemScheduledIncrementPrinter.this.lastItemSnapshots, item.getStatKind(), item.getStatObject());
                StatisticsItem increment = snapshot.subtract(lastSnapshot);
                Interceptor inteceptor = item.getInterceptor();
                String inteceptorStr = StatisticsItemScheduledIncrementPrinter.this.formatInterceptor(inteceptor);
                if (inteceptor != null) {
                    inteceptor.reset();
                }
                StatisticsItemSampleBrief brief = StatisticsItemScheduledIncrementPrinter.this.getSampleBrief(item.getStatKind(), item.getStatObject());
                if (StatisticsItemScheduledIncrementPrinter.this.hasIncreased(increment)) {
                    StatisticsItemScheduledIncrementPrinter.this.printer.print(StatisticsItemScheduledIncrementPrinter.this.name, increment, inteceptorStr, brief.toString());
                }
                StatisticsItemScheduledIncrementPrinter.this.setItemSnapshot(StatisticsItemScheduledIncrementPrinter.this.lastItemSnapshots, snapshot);
                brief.reset();
            }
        }, this.getInitialDelay(), this.interval, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!StatisticsItemScheduledIncrementPrinter.this.enabled()) {
                    return;
                }
                StatisticsItem snapshot = item.snapshot();
                StatisticsItemSampleBrief brief = StatisticsItemScheduledIncrementPrinter.this.getSampleBrief(item.getStatKind(), item.getStatObject());
                brief.sample(snapshot);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private StatisticsItem getItemSnapshot(ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> snapshots, String kind, String key) {
        ConcurrentHashMap<String, StatisticsItem> itemMap = snapshots.get(kind);
        return itemMap != null ? itemMap.get(key) : null;
    }

    private StatisticsItemSampleBrief getSampleBrief(String kind, String key) {
        ConcurrentHashMap<String, StatisticsItemSampleBrief> itemMap = this.sampleBriefs.get(kind);
        return itemMap != null ? itemMap.get(key) : null;
    }

    private void setItemSnapshot(ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> snapshots, StatisticsItem item) {
        ConcurrentHashMap<String, StatisticsItem> oldItemMap;
        String kind = item.getStatKind();
        String key = item.getStatObject();
        ConcurrentHashMap<String, StatisticsItem> itemMap = snapshots.get(kind);
        if (itemMap == null && (oldItemMap = snapshots.putIfAbsent(kind, itemMap = new ConcurrentHashMap())) != null) {
            itemMap = oldItemMap;
        }
        itemMap.put(key, item);
    }

    private void setItemSampleBrief(String kind, String key, StatisticsItemSampleBrief brief) {
        ConcurrentHashMap<String, StatisticsItemSampleBrief> oldItemMap;
        ConcurrentHashMap<String, StatisticsItemSampleBrief> itemMap = this.sampleBriefs.get(kind);
        if (itemMap == null && (oldItemMap = this.sampleBriefs.putIfAbsent(kind, itemMap = new ConcurrentHashMap())) != null) {
            itemMap = oldItemMap;
        }
        itemMap.put(key, brief);
    }

    private boolean hasIncreased(StatisticsItem increment) {
        if (increment.getInvokeTimes().get() == 0L) {
            return false;
        }
        for (AtomicLong acc : increment.getItemAccumulates()) {
            if (acc.get() == 0L) continue;
            return true;
        }
        return false;
    }

    private String formatInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            return "";
        }
        if (interceptor instanceof StatisticsBriefInterceptor) {
            StringBuilder sb = new StringBuilder();
            StatisticsBriefInterceptor briefInterceptor = (StatisticsBriefInterceptor)interceptor;
            for (StatisticsBrief brief : briefInterceptor.getStatisticsBriefs()) {
                long max = brief.getMax();
                long tp999 = Math.min(brief.tp999(), max);
                sb.append(SEPERATOR).append(max);
                sb.append(SEPERATOR).append(String.format("%.2f", brief.getAvg()));
                sb.append(SEPERATOR).append(tp999);
            }
            return sb.toString();
        }
        return "";
    }

    public static class ItemSampleBrief {
        private long max;
        private long min;
        private long total;
        private long cnt;

        public ItemSampleBrief() {
            this.reset();
        }

        public void sample(long value) {
            this.max = Math.max(this.max, value);
            this.min = Math.min(this.min, value);
            this.total += value;
            ++this.cnt;
        }

        public void reset() {
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.total = 0L;
            this.cnt = 0L;
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.cnt > 0L ? this.min : 0L;
        }

        public long getTotal() {
            return this.total;
        }

        public long getCnt() {
            return this.cnt;
        }

        public double getAvg() {
            return this.cnt != 0L ? (double)this.total / (double)this.cnt : 0.0;
        }
    }

    public static class StatisticsItemSampleBrief {
        private StatisticsItem lastSnapshot;
        public String[] itemNames;
        public ItemSampleBrief[] briefs;

        public StatisticsItemSampleBrief(StatisticsItem statItem, String[] itemNames) {
            this.lastSnapshot = statItem.snapshot();
            this.itemNames = itemNames;
            this.briefs = new ItemSampleBrief[itemNames.length];
            for (int i = 0; i < itemNames.length; ++i) {
                this.briefs[i] = new ItemSampleBrief();
            }
        }

        public synchronized void reset() {
            for (ItemSampleBrief brief : this.briefs) {
                brief.reset();
            }
        }

        public synchronized void sample(StatisticsItem snapshot) {
            if (snapshot == null) {
                return;
            }
            for (int i = 0; i < this.itemNames.length; ++i) {
                String name = this.itemNames[i];
                long lastValue = this.lastSnapshot != null ? this.lastSnapshot.getItemAccumulate(name).get() : 0L;
                long increment = snapshot.getItemAccumulate(name).get() - lastValue;
                this.briefs[i].sample(increment);
            }
            this.lastSnapshot = snapshot;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.briefs.length; ++i) {
                ItemSampleBrief brief = this.briefs[i];
                sb.append(StatisticsItemScheduledIncrementPrinter.SEPERATOR).append(brief.getMax());
                sb.append(StatisticsItemScheduledIncrementPrinter.SEPERATOR).append(String.format("%.2f", brief.getAvg()));
            }
            return sb.toString();
        }
    }
}

