/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.alibaba.ons.open.trace.core.hook.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TraceProducerFactory {
    private static Map<String, Object> dispatcherTable = new ConcurrentHashMap<String, Object>();
    private static AtomicBoolean isStarted = new AtomicBoolean(false);
    private static DefaultMQProducer traceProducer;

    public static DefaultMQProducer getTraceDispatcherProducer(Properties properties) {
        if (traceProducer == null) {
            SessionCredentials sessionCredentials = new SessionCredentials();
            Properties sessionProperties = new Properties();
            String accessKey = properties.getProperty("AccessKey");
            String secretKey = properties.getProperty("SecretKey");
            sessionProperties.put("AccessKey", accessKey);
            sessionProperties.put("SecretKey", secretKey);
            sessionCredentials.updateContent(sessionProperties);
            traceProducer = new DefaultMQProducer(new ClientRPCHook(sessionCredentials));
            traceProducer.setProducerGroup(accessKey + "_INNER_TRACE_PRODUCER");
            traceProducer.setSendMsgTimeout(5000);
            traceProducer.setInstanceName(properties.getProperty("InstanceName", String.valueOf(System.currentTimeMillis())));
            String nameSrv = properties.getProperty("NAMESRV_ADDR");
            if (nameSrv == null) {
                TopAddressing topAddressing = new TopAddressing(properties.getProperty("ADDRSRV_URL"));
                nameSrv = topAddressing.fetchNSAddr();
            }
            traceProducer.setNamesrvAddr(nameSrv);
            traceProducer.setVipChannelEnabled(false);
            int maxSize = Integer.parseInt(properties.getProperty("MaxMsgSize", "128000"));
            traceProducer.setMaxMessageSize(maxSize - 10000);
        }
        return traceProducer;
    }

    public static void registerTraceDispatcher(String dispatcherId) throws MQClientException {
        dispatcherTable.put(dispatcherId, new Object());
        if (traceProducer != null && isStarted.compareAndSet(false, true)) {
            traceProducer.start();
        }
    }

    public static void unregisterTraceDispatcher(String dispatcherId) {
        dispatcherTable.remove(dispatcherId);
        if (dispatcherTable.isEmpty() && traceProducer != null && isStarted.get()) {
            traceProducer.shutdown();
        }
    }
}

