/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.sdk.dependencies.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.aliyun.opensearch.util.HttpClientFactory;
import com.aliyun.opensearch.util.HttpResult;
import java.io.IOException;
import java.util.Map;

public class HttpClientManager {
    private static HttpClientFactory httpClientFactory = new HttpClientFactory(0, 0, 0);

    public static PoolingClientConnectionManager getConnectionManager() {
        return HttpClientManager.httpClientFactory.connectionManager;
    }

    public static void setMaxConnections(int maxConnections) {
        if (maxConnections > 0 && maxConnections != httpClientFactory.getMaxConnections()) {
            if (httpClientFactory != null) {
                httpClientFactory.shutdownIdleConnectionMonitor();
            }
            httpClientFactory = new HttpClientFactory(0, 0, maxConnections);
        }
    }

    public static void setTimeout(int timeout) {
        httpClientFactory.setTimeOut(timeout);
    }

    public static void enableGzip() {
        httpClientFactory.enableGzip();
    }

    public static void setConnectTimeout(int connectTimeout) {
        httpClientFactory.setConnectTimeout(connectTimeout);
    }

    public static HttpResult doPost(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return httpClientFactory.doPost(requestPath, headers, body, encoding);
    }

    public static HttpResult doPatch(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return httpClientFactory.doPatch(requestPath, headers, body, encoding);
    }

    public static HttpResult doDelete(String requestPath, Map<String, String> headers, String encoding) throws IOException {
        return httpClientFactory.doDelete(requestPath, headers, encoding);
    }

    public static HttpResult doGet(String url, Map<String, String> headers, String encoding, boolean isPB) throws IOException {
        return httpClientFactory.doGet(url, headers, encoding, isPB);
    }

    public static HttpResult doPut(String requestPath, Map<String, String> headers, String body, String encoding) throws IOException {
        return httpClientFactory.doPut(requestPath, headers, body, encoding);
    }
}

