/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CodecUtils {
    public static String generateMD5(String data) {
        return CodecUtils.hashString(data, "MD5");
    }

    public static String generateSHA1(String data) {
        return CodecUtils.hashString(data, "SHA-1");
    }

    public static String generateSHA256(String data) {
        return CodecUtils.hashString(data, "SHA-256");
    }

    private static String hashString(String data, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(data.getBytes("UTF-8"));
            return CodecUtils.convertByteArrayToHexString(hashedBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not generate hash from String", ex);
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public static String signature(String stringToSign, String secretString) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] keyBytes = secretString.getBytes("UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        byte[] text = stringToSign.getBytes("UTF-8");
        byte[] doFinalBytes = mac.doFinal(text);
        return BaseEncoding.base64().encode(doFinalBytes);
    }
}

