/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.suggestion.SuggestionService;
import java.util.HashMap;
import java.util.Map;

public class SuggestionClient
implements SuggestionService.Iface {
    private OpenSearchClient client;
    private static final String ROOT = "suggestions";
    private String suggestionName;
    private String query = "";
    private byte hits = (byte)10;

    public SuggestionClient(String suggestionName, OpenSearchClient client) {
        this.suggestionName = suggestionName;
        this.client = client;
    }

    public SuggestionClient setQuery(String query) {
        this.query = query;
        return this;
    }

    public SuggestionClient setHits(byte hits) {
        this.hits = hits;
        return this;
    }

    @Override
    public String search() throws OpenSearchException, OpenSearchClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", this.query);
        params.put("hit", Byte.toString(this.hits));
        return this.doGet(this.suggestionName + "/actions/search", params);
    }

    private String doGet(String identity, Map<String, String> params) throws OpenSearchClientException {
        return this.client.call(this.createResourcePath(identity), params, "GET");
    }

    private String createResourcePath(String identity) {
        String path = String.format("/%s/%s", ROOT, identity);
        return path;
    }
}

