/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.client.ErrorResult;
import com.aliyun.opensearch.client.OpenSearchResponse;
import com.aliyun.opensearch.exceptions.ThriftSerializationException;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.Log;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.LogFactory;
import com.aliyun.opensearch.sdk.dependencies.org.apache.thrift.TBase;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONException;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.util.JsonUtil;
import com.aliyun.opensearch.util.OpenSearchJSONProtocol;
import com.aliyun.opensearch.util.ThriftIO;

public class JsonUtilWrapper {
    private static final Log log = LogFactory.getLog(JsonUtilWrapper.class);

    public static String toJson(TBase obj) throws JSONException {
        try {
            return ThriftIO.toStringAsProtocol(obj, OpenSearchJSONProtocol.class);
        }
        catch (ThriftSerializationException e) {
            throw new JSONException(e);
        }
    }

    public static <T> T fromJson(String jsonString, Class<T> tClass) throws JSONException {
        return JsonUtil.fromJson(jsonString, tClass);
    }

    public static OpenSearchResponse fromJson(String str) {
        JSONObject jsonObject = new JSONObject(str);
        OpenSearchResponse openSearchResponse = new OpenSearchResponse();
        if (jsonObject.has("request_id")) {
            openSearchResponse.setRequest_id(jsonObject.getString("request_id"));
        }
        if (jsonObject.has("status")) {
            openSearchResponse.setStatus(jsonObject.getString("status"));
        }
        if (jsonObject.has("tracer")) {
            openSearchResponse.setTracer(jsonObject.getString("tracer"));
        }
        if (jsonObject.has("errors")) {
            JSONArray jsonArray = jsonObject.getJSONArray("errors");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject errorJsonObject = jsonArray.getJSONObject(i);
                ErrorResult errorResult = JsonUtilWrapper.fromJsonObject(errorJsonObject);
                openSearchResponse.addError(errorResult);
            }
        }
        if (jsonObject.has("result")) {
            openSearchResponse.setResult(jsonObject.get("result"));
        }
        return openSearchResponse;
    }

    private static ErrorResult fromJsonObject(JSONObject jsonObject) {
        ErrorResult errorResult = new ErrorResult();
        if (jsonObject.has("code")) {
            errorResult.setCode(jsonObject.getInt("code"));
        }
        if (jsonObject.has("message")) {
            errorResult.setMessage(jsonObject.getString("message"));
        }
        return errorResult;
    }
}

