/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.Header;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.HttpEntity;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.HttpResponse;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.StatusLine;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.HttpClient;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.entity.GzipDecompressingEntity;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.methods.HttpDelete;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.methods.HttpGet;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.methods.HttpPatch;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.methods.HttpPost;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.client.methods.HttpRequestBase;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.conn.scheme.PlainSocketFactory;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.conn.scheme.Scheme;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.conn.scheme.SchemeRegistry;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.conn.ssl.SSLSocketFactory;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.entity.StringEntity;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.impl.client.DefaultHttpClient;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.HttpConnectionParams;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.params.HttpParams;
import com.aliyun.opensearch.sdk.dependencies.org.apache.http.util.EntityUtils;
import com.aliyun.opensearch.util.DaemonThreadFactory;
import com.aliyun.opensearch.util.HttpResult;
import com.aliyun.opensearch.util.IdleConnectionMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    private static int CLEAN_INIT_DELAY = 5;
    private static int clean_check_interval = 200;
    private int maxConnections = 50;
    private int timeout = 10000;
    private int connectTimeout = 5000;
    private boolean gzip = false;
    private String version = "v3.1";
    private HttpClient httpClient;
    private HttpParams params;
    private ScheduledExecutorService scheduledExeService;
    public PoolingClientConnectionManager connectionManager;

    public HttpClientFactory(int timeout, int connectTimeout, int connections) {
        this(timeout, connectTimeout, connections, CLEAN_INIT_DELAY, clean_check_interval);
    }

    public HttpClientFactory(int timeout, int connectTimeout, int connections, int cleanIdleConnInitDelay, int cleanIdleConnInterval) {
        if (timeout <= 0) {
            timeout = this.timeout;
        }
        if (connectTimeout <= 0) {
            connectTimeout = this.connectTimeout;
        }
        if (connections > 0 && this.maxConnections != connections) {
            this.maxConnections = connections;
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, SSLSocketFactory.getSocketFactory()));
        this.connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.connectionManager.setMaxTotal(this.maxConnections);
        this.connectionManager.setDefaultMaxPerRoute(this.maxConnections);
        this.scheduledExeService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("Http-client-ConenctionPool-Monitor"));
        this.scheduledExeService.scheduleAtFixedRate(new IdleConnectionMonitor(this.connectionManager), CLEAN_INIT_DELAY, clean_check_interval, TimeUnit.MILLISECONDS);
        this.httpClient = new DefaultHttpClient(this.connectionManager);
        this.params = this.httpClient.getParams();
        HttpConnectionParams.setSoTimeout(this.params, timeout);
        HttpConnectionParams.setConnectionTimeout(this.params, connectTimeout);
        HttpConnectionParams.setTcpNoDelay(this.params, Boolean.TRUE);
        HttpConnectionParams.setStaleCheckingEnabled(this.params, Boolean.FALSE);
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setGzip() {
        this.gzip = true;
    }

    public void setTimeOut(int timeout) {
        if (timeout > 0 && timeout != this.timeout) {
            this.timeout = timeout;
            HttpConnectionParams.setSoTimeout(this.params, this.timeout);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0 && connectTimeout != this.connectTimeout) {
            this.connectTimeout = connectTimeout;
            HttpConnectionParams.setConnectionTimeout(this.params, this.connectTimeout);
        }
    }

    public HttpResult doPost(String reqURL, Map<String, String> headers, String body, String encoding) throws IOException {
        HttpPost httpPost = new HttpPost(reqURL);
        if (!StringUtils.isEmpty(body)) {
            httpPost.setEntity(new StringEntity(body, encoding));
        }
        return this.doPost(reqURL, headers, encoding, httpPost);
    }

    public HttpResult doPatch(String reqURL, Map<String, String> headers, String body, String encoding) throws IOException {
        HttpPatch httpPatch = new HttpPatch(reqURL);
        if (!StringUtils.isEmpty(body)) {
            httpPatch.setEntity(new StringEntity(body, encoding));
        }
        return this.doPost(reqURL, headers, encoding, httpPatch);
    }

    public HttpResult doDelete(String reqURL, Map<String, String> headers, String encoding) throws IOException {
        HttpDelete httpDelete = new HttpDelete(reqURL);
        return this.doPost(reqURL, headers, encoding, httpDelete);
    }

    private <T extends HttpRequestBase> HttpResult doPost(String reqURL, Map<String, String> headers, String encoding, T httpRequest) throws IOException {
        httpRequest.setHeader("User-Agent", "opensearch/java sdk " + this.version);
        if (this.gzip) {
            httpRequest.setHeader("Accept-Encoding", "gzip");
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpRequest.setHeader(header.getKey(), header.getValue());
        }
        LOG.debug("--------POST Headers: --------");
        for (Header header : httpRequest.getAllHeaders()) {
            LOG.debug(header.toString());
        }
        LOG.debug("--------------------------------");
        LOG.debug("httpRequest: " + httpRequest);
        HttpResponse response = this.httpClient.execute(httpRequest);
        this.validateResponse(response, httpRequest);
        String result = this.doPost(reqURL, response.getEntity(), encoding, response.getStatusLine());
        StatusLine statusLine = response.getStatusLine();
        ArrayList<Header> requestHeaders = Lists.newArrayList(httpRequest.getAllHeaders());
        ArrayList<Header> responseHeaders = Lists.newArrayList(response.getAllHeaders());
        return new HttpResult(statusLine.getStatusCode(), statusLine.getReasonPhrase(), result, httpRequest.getURI(), requestHeaders, responseHeaders);
    }

    private String doPost(String reqURL, HttpEntity entity, String encoding, StatusLine statusLine) throws IOException {
        String responseContent = "";
        if (entity == null) {
            LOG.warn("Http entity is null! request url is {},response status is {}", (Object)reqURL, (Object)statusLine);
            return responseContent;
        }
        Header contentEncoding = entity.getContentEncoding();
        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(entity);
            responseContent = EntityUtils.toString((HttpEntity)gzipEntity, encoding);
        } else {
            responseContent = EntityUtils.toString(entity, encoding);
        }
        EntityUtils.consume(entity);
        return responseContent;
    }

    public HttpResult doGet(String url, Map<String, String> headers, String encoding, boolean isPB) throws IOException {
        LOG.debug("GET url: " + url);
        HttpGet httpget = new HttpGet(url);
        httpget.setHeader("User-Agent", "opensearch/java sdk " + this.version);
        if (this.gzip) {
            httpget.setHeader("Accept-Encoding", "gzip");
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpget.setHeader(header.getKey(), header.getValue());
        }
        LOG.debug("--------------- Get Headers: ---------------");
        for (Header header : httpget.getAllHeaders()) {
            LOG.debug(header.toString());
        }
        LOG.debug("--------------------------------");
        LOG.debug(httpget.toString());
        HttpResponse response = this.httpClient.execute(httpget);
        this.validateResponse(response, httpget);
        String result = this.doGetResponseContent(response.getEntity(), encoding, isPB);
        StatusLine statusLine = response.getStatusLine();
        ArrayList<Header> requestHeaders = Lists.newArrayList(httpget.getAllHeaders());
        ArrayList<Header> responseHeaders = Lists.newArrayList(response.getAllHeaders());
        return new HttpResult(statusLine.getStatusCode(), statusLine.getReasonPhrase(), result, httpget.getURI(), requestHeaders, responseHeaders);
    }

    private String doGetResponseContent(HttpEntity entity, String encoding, boolean isPB) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream is;
        String result = "";
        if (entity == null) {
            return result;
        }
        Header header = entity.getContentEncoding();
        if (header != null && header.getValue().equalsIgnoreCase("gzip")) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(entity);
            is = gzipEntity.getContent();
        } else {
            is = entity.getContent();
        }
        if (isPB) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = is.read(bytes)) != -1) {
                byteArrayOutputStream.write(bytes, 0, len);
            }
        } else {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int count = -1;
            while ((count = is.read(data, 0, 4096)) != -1) {
                outStream.write(data, 0, count);
            }
            data = null;
            return new String(outStream.toByteArray(), encoding);
        }
        byte[] temp = byteArrayOutputStream.toByteArray();
        result = new String(temp, "ISO8859-1");
        return result;
    }

    public void shutdownIdleConnectionMonitor() {
        if (this.scheduledExeService != null) {
            this.scheduledExeService.shutdown();
        }
    }

    private void validateResponse(HttpResponse response, HttpRequestBase request) {
        StatusLine status = response.getStatusLine();
        int code = status.getStatusCode();
        if (code >= 400) {
            LOG.warn("Did not receive successful HTTP response: status code = {}, status message = {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
            try {
                request.abort();
            }
            catch (Throwable t) {
                LOG.warn("failed to abort request", t);
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static void setCleanIdelConnCheckInterval(int checkInterval) {
        clean_check_interval = checkInterval;
    }
}

