/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.search;

import com.aliyun.opensearch.SearcherClient;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.base.Preconditions;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.general.SearchResult;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepPageingIterator
implements Iterator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(DeepPageingIterator.class);
    private SearcherClient searcherClient;
    private SearchParams searchParams;
    private String cursorMark;
    private int remain;
    private String next;
    private long pagingIntervals = 100L;

    public DeepPageingIterator(SearcherClient searcherClient, SearchParams searchParams) {
        this.searcherClient = searcherClient;
        this.searchParams = new SearchParams(searchParams);
    }

    public void setPagingIntervals(long pageIntervals) {
        this.pagingIntervals = pageIntervals;
    }

    @Override
    public boolean hasNext() {
        int total;
        JSONObject resultPart;
        String status;
        JSONObject json;
        String result;
        SearchResult searchResult;
        block14: {
            if (null == this.cursorMark) {
                try {
                    searchResult = this.searcherClient.execute(this.searchParams);
                    result = searchResult.getResult();
                    json = new JSONObject(result);
                    status = json.getString("status");
                    resultPart = (JSONObject)json.get("result");
                    total = resultPart.getInt("total");
                    String next_scroll_id = resultPart.getString("scroll_id");
                    this.remain = total;
                    if ("OK".equals(status)) {
                        if (this.remain == 0) {
                            LOG.warn("no result found.");
                        } else {
                            this.cursorMark = next_scroll_id;
                        }
                        break block14;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        if (this.remain == 0) {
            return false;
        }
        try {
            Thread.sleep(this.pagingIntervals);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        Preconditions.checkNotNull(this.cursorMark);
        this.searchParams.getDeepPaging().setScrollId(this.cursorMark);
        try {
            searchResult = this.searcherClient.execute(this.searchParams);
            result = searchResult.getResult();
            json = new JSONObject(result);
            status = json.getString("status");
            resultPart = (JSONObject)json.get("result");
            total = resultPart.getInt("total");
            int num = resultPart.getInt("num");
            String next_scroll_id = resultPart.getString("scroll_id");
            this.remain = total;
            this.next = result;
            if ("OK".equals(status)) {
                if (this.remain == 0) {
                    LOG.warn("no result remain for next paging.");
                    return false;
                }
                if (num == 0) {
                    LOG.warn("result found, but shows nothing.");
                    return false;
                }
                this.cursorMark = next_scroll_id;
                return true;
            }
            this.remain = -1;
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String next() {
        Preconditions.checkNotNull(this.next);
        return this.next;
    }

    @Override
    public void remove() {
    }
}

