/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.auth.Authentication;
import com.aliyun.opensearch.auth.OpenSearchAuthentication;
import com.aliyun.opensearch.client.ErrorResult;
import com.aliyun.opensearch.client.OpenSearchResponse;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.lang.StringUtils;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.Log;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.LogFactory;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONException;
import com.aliyun.opensearch.sdk.generated.OpenSearch;
import com.aliyun.opensearch.sdk.generated.OpenSearchService;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.commons.TraceInfo;
import com.aliyun.opensearch.util.HttpClientManager;
import com.aliyun.opensearch.util.HttpResult;
import com.aliyun.opensearch.util.JsonUtilWrapper;
import com.aliyun.opensearch.util.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OpenSearchClient
implements OpenSearchService.Iface {
    private static final Log log = LogFactory.getLog(OpenSearchClient.class);
    public static final String METHOD_GET = "GET";
    public static final String DEFAULT_METHOD = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_DELETE = "DELETE";
    public static final String POST_BODY_PARAM_KEY = "_POST_BODY";
    public static final String ENCODE_UTF8 = "utf-8";
    private static final String version = "v3";
    private String host;
    private String baseURI = "/v3/openapi";
    private static final int ERROR_INTERNAL = 1000;
    private Authentication authentication;

    public OpenSearchClient(OpenSearch opensearch) {
        this.host = opensearch.getHost();
        if (this.host == null || this.host.length() == 0) {
            throw new IllegalArgumentException("host not speicifed.");
        }
        this.host = Utils.normalize(this.host);
        this.authentication = new OpenSearchAuthentication(this.host, opensearch.getAccessKey(), opensearch.getSecret());
        if (opensearch.isSetGzip() && opensearch.isSetGzip()) {
            HttpClientManager.setGzip();
        }
        if (opensearch.isSetTimeout() && opensearch.getTimeout() > 0) {
            HttpClientManager.setTimeout(opensearch.getTimeout());
        }
        if (opensearch.isSetConnectTimeout() && opensearch.getConnectTimeout() > 0) {
            HttpClientManager.setConnectTimeout(opensearch.getConnectTimeout());
        }
    }

    @Override
    public String call(String path, Map<String, String> params, String method) throws OpenSearchClientException {
        return this.authAndCall(path, params, method).getResult();
    }

    public OpenSearchResult callAndDecodeResult(String path, Map<String, String> params, String method) throws OpenSearchException, OpenSearchClientException {
        HttpResult result = this.authAndCall(path, params, method);
        return OpenSearchClient.fromHttpResult(result);
    }

    protected HttpResult authAndCall(String path, Map<String, String> params, String method) throws OpenSearchClientException {
        String uri = this.baseURI;
        String request_path = uri + path;
        String url = this.host + request_path;
        TreeMap<String, String> opensearch_headers = this.authentication.createOpenSearchHeaders();
        TreeMap<String, Object> signParameters = this.authentication.createSignParameters(method, request_path, opensearch_headers, params);
        String signature = this.authentication.createAliyunSign(signParameters);
        Map<String, String> headers = this.authentication.createHttpHeaders(opensearch_headers, signParameters, signature);
        try {
            return this.doRequest(url, headers, params, method, false);
        }
        catch (Throwable e) {
            log.debug(String.format("failed to request [%s]", url), e);
            throw new OpenSearchClientException(e);
        }
    }

    protected HttpResult doRequest(String url, Map<String, String> headers, Map<String, String> requestParams, String method, boolean isPB) throws IOException {
        HttpResult httpResult = new HttpResult();
        if (method.equals(METHOD_POST)) {
            httpResult = HttpClientManager.doPost(url, headers, requestParams.get(POST_BODY_PARAM_KEY), ENCODE_UTF8);
        } else if (method.equals("GET")) {
            url = url + Utils.getHTTPParamsAsUrlStr(method, requestParams);
            httpResult = HttpClientManager.doGet(url, headers, ENCODE_UTF8, isPB);
        } else if (method.equals(METHOD_DELETE)) {
            httpResult = HttpClientManager.doDelete(url, headers, ENCODE_UTF8);
        } else if (method.equals(METHOD_PATCH)) {
            httpResult = HttpClientManager.doPatch(url, headers, requestParams.get(POST_BODY_PARAM_KEY), ENCODE_UTF8);
        }
        return httpResult;
    }

    protected static OpenSearchResult fromHttpResult(HttpResult httpResult) throws OpenSearchException, OpenSearchClientException {
        OpenSearchResponse openSearchResponse;
        if (httpResult.getCode() >= 400) {
            OpenSearchResponse openSearchResponse2;
            OpenSearchException openSearchException = new OpenSearchException();
            String resultString = httpResult.getResult();
            if (StringUtils.isEmpty(resultString)) {
                openSearchException.setCode(1000);
                openSearchException.setMessage(httpResult.getReason());
                throw openSearchException;
            }
            try {
                openSearchResponse2 = JsonUtilWrapper.fromJson(httpResult.getResult());
            }
            catch (JSONException e) {
                openSearchException.setCode(1000);
                openSearchException.setMessage(httpResult.toString());
                throw openSearchException;
            }
            openSearchException.setRequestId(openSearchResponse2.getRequest_id());
            List<ErrorResult> errorResults = openSearchResponse2.getErrors();
            if (errorResults == null || errorResults.size() == 0) {
                openSearchException.setCode(1000);
                openSearchException.setMessage(httpResult.toString());
                throw openSearchException;
            }
            ErrorResult errorResult = errorResults.get(0);
            openSearchException.setCode(errorResult.getCode());
            openSearchException.setMessage(errorResult.getMessage());
            throw openSearchException;
        }
        try {
            openSearchResponse = JsonUtilWrapper.fromJson(httpResult.getResult());
        }
        catch (JSONException e) {
            throw new OpenSearchClientException(String.format("parse result failed: %s", httpResult.toString()), e);
        }
        OpenSearchResult openSearchResult = new OpenSearchResult();
        TraceInfo traceInfo = new TraceInfo();
        traceInfo.setRequestId(openSearchResponse.getRequest_id());
        traceInfo.setTracer(openSearchResponse.getTracer());
        openSearchResult.setTraceInfo(traceInfo);
        openSearchResult.setResult(openSearchResponse.getResultString());
        return openSearchResult;
    }
}

