/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.OpenSearchClient;
import com.aliyun.opensearch.client.ResourceClient;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.Log;
import com.aliyun.opensearch.sdk.dependencies.org.apache.commons.logging.LogFactory;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.aliyun.opensearch.sdk.generated.document.DocumentService;
import java.util.Map;

public class DocumentClient
implements DocumentService.Iface {
    private static final Log log = LogFactory.getLog(DocumentClient.class);
    private ResourceClient resourceClient;
    private JSONArray docBuffer = new JSONArray();

    public DocumentClient(OpenSearchClient client) {
        this.resourceClient = new ResourceClient("/apps", client);
    }

    public void add(Map<String, Object> fields) {
        this.pushOneDoc(fields, Command.ADD);
    }

    public void update(Map<String, Object> fields) {
        this.pushOneDoc(fields, Command.UPDATE);
    }

    public void remove(Map<String, Object> fields) {
        this.pushOneDoc(fields, Command.DELETE);
    }

    private void pushOneDoc(Map<String, Object> fields, Command command) {
        JSONObject JSONFields = new JSONObject();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            JSONFields.put(entry.getKey(), entry.getValue());
        }
        JSONObject json = new JSONObject();
        json.put("cmd", command.toString());
        json.put("fields", JSONFields);
        this.docBuffer.put(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchResult commit(String appName, String tableName) throws OpenSearchException, OpenSearchClientException {
        OpenSearchResult result;
        try {
            result = this.doPush(this.docBuffer, appName, tableName);
        }
        finally {
            this.docBuffer = new JSONArray();
        }
        return result;
    }

    @Override
    public OpenSearchResult push(String docsJson, String appName, String tableName) throws OpenSearchException, OpenSearchClientException {
        JSONArray docs = new JSONArray(docsJson);
        return this.doPush(docs, appName, tableName);
    }

    private OpenSearchResult doPush(JSONArray jsonArray, String appName, String tableName) throws OpenSearchException, OpenSearchClientException {
        return this.resourceClient.post(this.createPushPath(appName, tableName), jsonArray.toString());
    }

    private String createPushPath(String appName, String tableName) {
        return String.format("/%s/%s/actions/bulk", appName, tableName);
    }
}

