package com.aliyun.opensearch.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;

import org.apache.http.client.methods.HttpGet;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

/**
 * The static Utils.
 *
 * @author Ken
 */
public class Utils {

	private static Random rand = new Random();

	public static int randInt(int min, int max) {
		int randomNum = rand.nextInt((max - min) + 1) + min;
		return randomNum;
	}

	public static String getHTTPParamsAsUrlStr(String method, Map<String, String> params) {
		if (!HttpGet.METHOD_NAME.equals(method) || params == null || params.size() <= 0) {
			return "";
		}

		List<String> paramstring = Lists.newLinkedList();
		for (Entry<String, String> entry : params.entrySet()) {
			String key = percentEncode(entry.getKey());
			String value = percentEncode(entry.getValue());
			StringBuilder sb = new StringBuilder();
			paramstring.add(sb.append(key).append("=").append(value).toString());
		}
		return "?" + Joiner.on("&").join(paramstring);
	}

	public static String urlEncodeWithUTF8(String value) {
		if (null == value)
			return null;
		String encode = "UTF-8";
		try {
			return URLEncoder.encode(value, encode);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("JVM DOES NOT SUPPORT " + encode + "?");
		}
	}

	public static String percentEncode(String value) {
		if (null == value)
			return null;
		return urlEncodeWithUTF8(value).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
	}

	public static String normalize(String str) {
		StringBuilder sb = new StringBuilder();
		sb.append(str.endsWith("/") ? str.substring(0, str.length() - 1) : str);
		return sb.toString();
	}
}
