package com.aliyun.opensearch.util;
/**
 * Created by dengwx on 16/9/9.
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;

public class OpenSearchJSONProtocol extends TSimpleJSONProtocol {
  private static final Log log = LogFactory.getLog(OpenSearchJSONProtocol.class);

  /**
   * Factory
   */
  public static class Factory implements TProtocolFactory {
    public TProtocol getProtocol(TTransport trans) {
      return new OpenSearchJSONProtocol(trans);
    }
  }

  /**
   * Constructor
   */
  public OpenSearchJSONProtocol(TTransport trans) {
    super(trans);
  }

  public void writeBool(boolean b) throws TException {
    writeContext_.write();
    if (b) {
      _writeStringData("true");
    } else {
      _writeStringData("false");
    }
  }
}
