/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.aliyun.opensearch.util;

import java.util.concurrent.TimeUnit;

import org.apache.http.conn.ClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author vongosling.fengj 2013-5-8
 */
public class IdleConnectionMonitor extends Thread {
	private final ClientConnectionManager connMgr;

	private final Logger log = LoggerFactory.getLogger(IdleConnectionMonitor.class);

	public IdleConnectionMonitor(ClientConnectionManager connMgr) {
		super();
		this.connMgr = connMgr;
	}

	@Override
	public void run() {
		try {
			// Close expired connections
			connMgr.closeExpiredConnections();
			// Optionally, close connections
			// that have been idle longer than 30 sec
			connMgr.closeIdleConnections(2, TimeUnit.SECONDS);
		} catch (Exception e) {
			log.error("IdleConnectionMonitor error", e);
		}
	}

}
