/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.conf;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class SessionState {
    private static ThreadLocal<SessionState> tss = new InheritableThreadLocal<SessionState>(){

        @Override
        public SessionState initialValue() {
            return new SessionState();
        }

        @Override
        protected SessionState childValue(SessionState parentValue) {
            return new SessionState(parentValue);
        }
    };
    private Odps odps;
    private JobConf defaultJob;
    private boolean isLocalRun;
    private boolean isCostMode;
    private boolean isSqlMode;
    private String tunnelEndpoint;
    private Map<String, String> aliases;
    private boolean internalCli = false;
    private String commandText = "";
    private static final String OLD_PROJNAME_KEY = "odps.project.name";
    private static final String OLD_ENDPOINT_KEY = "odps.end.point";
    private static final String OLD_ACCESSID_KEY = "odps.access.id";
    private static final String OLD_ACCESSKEY_KEY = "odps.access.key";
    private static final String OLD_RUNMODE_KEY = "odps.runner.mode";
    private static final String OLD_RESOURCE_KEY = "odps.cache.resources";
    private static final String OLD_CP_RESOURCE_KEY = "odps.classpath.resources";
    private static final String OLD_CONTEXT_FILE = "odps.exec.context.file";
    private static final String OLD_ACCOUNT_PROVIDER_KEY = "odps.account.provider";
    private static final String OLD_TAOBAO_TOKEN_KEY = "odps.taobao.token";
    private static final String OLD_TAOBAO_ALGORITHM_KEY = "odps.taobao.algorithm";
    private static final String LOCAL_TEMP_DIR = "odps.mapred.local.temp.dir";
    private static final String LOCAL_TEMP_RETAIN = "odps.mapred.local.temp.retain";
    private static final String LOCAL_RECORD_LIMIT = "odps.mapred.local.record.download.limit";
    private static final String LOCAL_TUNNEL_ENDPOINT = "odps.tunnel.end.point";
    public static final String LOCAL_DOWNLOAD_MODE = "odps.mapred.local.download.mode";
    public static final String LOCAL_SECURITY_ENABLE = "odps.local.security.enable";
    public static final String LOCAL_SECURITY_JNI_ENABLE = "odps.local.security.jni.enable";
    public static final String LOCAL_USER_DEFINE_POLICY = "odps.local.user.define.policy";
    public static final String COST = "cost";
    public static final String ODPS_JOB_COST_ESTIMATE = "odps.task.cost.estimate";
    public static final String MR_EXECUTION_MODE = "odps.mr.run.mode";
    public static final String MR_EXECUTION_SQL_QUERY = "odps.mr.sql.query";
    public static final String MR_EXECUTION_SQL_ERROR = "odps.mr.sql.error";
    public static final String MR_EXECUTION_SESSION_RESOURCES = "odps.sql.session.resources";
    private static final String LOCAL_INPUT_COLUMN_SEPERATOR = "odps.mapred.local.input.column.seperator";
    private static final String LOCAL_OUTPUT_COLUMN_SEPERATOR = "odps.mapred.local.output.column.seperator";
    private static final String MR_JOB_CONF = "odps.mr.job.conf";

    private SessionState() {
        try {
            this.aliases = new HashMap<String, String>();
            this.defaultJob = new JobConf(false);
            String conf = System.getProperties().getProperty(MR_JOB_CONF);
            if (conf != null && !conf.isEmpty()) {
                try {
                    this.defaultJob.addResource(new FileInputStream(new File(conf)));
                }
                catch (FileNotFoundException e) {
                    System.err.print("conf file " + conf + " not found, ignored!");
                }
            }
            this.parseOldCli(this.defaultJob);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public SessionState(SessionState ss) {
        if (ss.odps != null) {
            this.odps = new Odps(ss.odps);
        }
        if (ss.defaultJob != null) {
            this.defaultJob = new JobConf(ss.defaultJob);
        }
        this.isLocalRun = ss.isLocalRun;
        this.aliases = new HashMap<String, String>();
        if (ss.aliases != null) {
            this.aliases.putAll(ss.aliases);
        }
    }

    private void loadContextFile(Properties prop) throws IOException {
        String fileName = prop.getProperty(OLD_CONTEXT_FILE);
        if (fileName == null) {
            return;
        }
        String jsonStr = FileUtils.readFileToString((File)new File(fileName));
        Gson gson = GsonObjectBuilder.get();
        Map context = (Map)gson.fromJson(jsonStr, Map.class);
        if (context == null) {
            return;
        }
        this.internalCli = true;
        this.getOdps().getRestClient().setIgnoreCerts(true);
        if (context.containsKey("settings")) {
            Map settings = (Map)context.get("settings");
            for (Map.Entry setting : settings.entrySet()) {
                this.defaultJob.set((String)setting.getKey(), (String)setting.getValue());
            }
        }
        if (context.containsKey("aliases")) {
            this.aliases = (Map)context.get("aliases");
        }
        if (context.containsKey("context")) {
            String runningCluster;
            Map ctx = (Map)context.get("context");
            Object priority = ctx.get("priority");
            if (priority instanceof Integer) {
                this.defaultJob.setInstancePriority((Integer)priority);
            } else if (priority instanceof Double) {
                this.defaultJob.setInstancePriority(((Double)priority).intValue());
            } else if (priority instanceof Long) {
                this.defaultJob.setInstancePriority(((Long)priority).intValue());
            } else {
                this.defaultJob.setInstancePriority(Integer.parseInt((String)priority));
            }
            OdpsHooks.clearRegisteredHooks();
            String hookString = (String)ctx.get("odpsHooks");
            if (!StringUtils.isNullOrEmpty((String)hookString)) {
                try {
                    String[] hooks = hookString.split(",");
                    ArrayList hookList = new ArrayList();
                    for (String hook : hooks) {
                        hookList.add(Class.forName(hook));
                    }
                    OdpsHooks.registerHooks(hookList);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            if (!StringUtils.isNullOrEmpty((String)(runningCluster = (String)ctx.get("runningCluster")))) {
                this.odps.instances().setDefaultRunningCluster(runningCluster);
            }
            if (ctx.get("logViewHost") != null) {
                String logViewHost = (String)ctx.get("logViewHost");
                this.odps.setLogViewHost(logViewHost);
            }
            if (ctx.containsKey("https_check")) {
                this.odps.getRestClient().setIgnoreCerts((Boolean)ctx.get("https_check") == false);
            }
        }
        if (context.containsKey("commandText")) {
            this.setCommandText((String)context.get("commandText"));
        }
    }

    private void parseOldCli(JobConf conf) {
        Properties prop = System.getProperties();
        String cost = prop.getProperty(COST);
        if (cost != null && "true".equals(cost)) {
            this.defaultJob.setBoolean(ODPS_JOB_COST_ESTIMATE, true);
            this.setCostMode(true);
        }
        if (prop.getProperty(OLD_ENDPOINT_KEY) != null) {
            String endpoint = prop.getProperty(OLD_ENDPOINT_KEY);
            String project = prop.getProperty(OLD_PROJNAME_KEY);
            String accessId = prop.getProperty(OLD_ACCESSID_KEY);
            String accessKey = prop.getProperty(OLD_ACCESSKEY_KEY);
            String runmode = prop.getProperty(OLD_RUNMODE_KEY, "remote");
            this.tunnelEndpoint = prop.getProperty(LOCAL_TUNNEL_ENDPOINT);
            if (runmode.equalsIgnoreCase("local")) {
                this.handleLocalMR(prop);
            } else {
                System.err.println("Running job in console.");
            }
            Account.AccountProvider accountProvider = Account.AccountProvider.ALIYUN;
            String apStr = prop.getProperty(OLD_ACCOUNT_PROVIDER_KEY);
            if (apStr != null) {
                apStr = apStr.trim().toUpperCase();
                try {
                    accountProvider = Account.AccountProvider.valueOf((String)apStr);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unsupport account provider:" + apStr);
                }
            }
            AliyunAccount account = null;
            switch (accountProvider) {
                case ALIYUN: {
                    account = new AliyunAccount(accessId, accessKey);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupport account provider:" + accountProvider);
                }
            }
            Odps odps = new Odps((Account)account);
            odps.setDefaultProject(project);
            odps.setEndpoint(endpoint);
            this.setOdps(odps);
            this.setLocalRun(runmode.equalsIgnoreCase("local"));
            String resources = prop.getProperty(OLD_RESOURCE_KEY, "");
            String cpresources = prop.getProperty(OLD_CP_RESOURCE_KEY, "");
            if (!resources.isEmpty() && !cpresources.isEmpty()) {
                resources = resources + ",";
            }
            resources = resources + cpresources;
            conf.setResources(resources);
        }
        try {
            this.loadContextFile(prop);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SessionState get() {
        return tss.get();
    }

    public Odps getOdps() {
        return this.odps;
    }

    public void setOdps(Odps odps) {
        this.odps = odps;
        if (this.internalCli) {
            odps.getRestClient().setIgnoreCerts(true);
        }
    }

    public JobConf getDefaultJob() {
        return this.defaultJob;
    }

    public boolean isLocalRun() {
        return this.isLocalRun;
    }

    public void setLocalRun(boolean b) {
        this.isLocalRun = b;
    }

    public void setCostMode(boolean b) {
        this.isCostMode = b;
    }

    public boolean isCostMode() {
        return this.isCostMode;
    }

    public void setDefaultJob(JobConf defaultJob) {
        this.defaultJob = defaultJob;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public void setTunnelEndpoint(String tunnelEndpoint) {
        this.tunnelEndpoint = tunnelEndpoint;
    }

    private void handleLocalMR(Properties prop) {
        boolean isSecurityEnabled;
        String outputColumnSeperator;
        String tunnelEndpoint;
        String tempRetain;
        String tempDir = prop.getProperty(LOCAL_TEMP_DIR);
        if (tempDir != null && !tempDir.isEmpty()) {
            this.defaultJob.set(LOCAL_TEMP_DIR, tempDir);
        }
        if ((tempRetain = prop.getProperty(LOCAL_TEMP_RETAIN)) != null && tempRetain.trim().equalsIgnoreCase("false")) {
            this.defaultJob.setBoolean(LOCAL_TEMP_RETAIN, false);
        } else {
            this.defaultJob.setBoolean(LOCAL_TEMP_RETAIN, true);
        }
        String limitDownloadCount = prop.getProperty(LOCAL_RECORD_LIMIT);
        if (limitDownloadCount != null && !limitDownloadCount.isEmpty()) {
            try {
                int limit = Integer.parseInt(limitDownloadCount);
                if (limit > 0) {
                    this.defaultJob.setInt(LOCAL_RECORD_LIMIT, limit);
                }
            }
            catch (Exception limit) {
                // empty catch block
            }
        }
        if (StringUtils.isNotBlank((String)(tunnelEndpoint = prop.getProperty(LOCAL_TUNNEL_ENDPOINT)))) {
            try {
                new URI(tunnelEndpoint);
                this.defaultJob.setStrings(LOCAL_TUNNEL_ENDPOINT, new String[]{tunnelEndpoint});
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid tunnel endpoint: " + tunnelEndpoint);
            }
        }
        String downloadMode = prop.getProperty(LOCAL_DOWNLOAD_MODE, "AUTO");
        this.defaultJob.set(LOCAL_DOWNLOAD_MODE, downloadMode);
        String inputColumnSeperator = prop.getProperty(LOCAL_INPUT_COLUMN_SEPERATOR);
        if (inputColumnSeperator != null && !inputColumnSeperator.isEmpty()) {
            this.defaultJob.set(LOCAL_INPUT_COLUMN_SEPERATOR, inputColumnSeperator);
        }
        if ((outputColumnSeperator = prop.getProperty(LOCAL_OUTPUT_COLUMN_SEPERATOR)) != null && !outputColumnSeperator.isEmpty()) {
            this.defaultJob.set(LOCAL_OUTPUT_COLUMN_SEPERATOR, outputColumnSeperator);
        }
        if (isSecurityEnabled = prop.getProperty(LOCAL_SECURITY_ENABLE, "false").equalsIgnoreCase("true")) {
            boolean isJNIEnabled = prop.getProperty(LOCAL_SECURITY_JNI_ENABLE, "false").equalsIgnoreCase("true");
            String userDefinePolicy = prop.getProperty(LOCAL_USER_DEFINE_POLICY, "");
            this.defaultJob.setBoolean(LOCAL_SECURITY_ENABLE, isSecurityEnabled);
            this.defaultJob.setBoolean(LOCAL_SECURITY_JNI_ENABLE, isJNIEnabled);
            this.defaultJob.set(LOCAL_USER_DEFINE_POLICY, userDefinePolicy);
        }
    }

    public String getCommandText() {
        return this.commandText;
    }

    public void setCommandText(String commandText) {
        this.commandText = this.stripNonValidXMLCharacters(commandText);
    }

    private String stripNonValidXMLCharacters(String in) {
        StringBuilder out = new StringBuilder();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current != '\t' && current != '\n' && current != '\r' && (current < ' ' || current > '\ud7ff') && (current < '\ue000' || current > '\ufffd')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public boolean isSqlMode() {
        return System.getProperty(MR_EXECUTION_MODE, "lot").equals("sql");
    }
}

