/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ShardDesc;
import com.aliyun.datahub.model.SplitShardRequest;
import com.aliyun.datahub.model.SplitShardResult;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SplitShardResultJsonDeser
implements Deserializer<SplitShardResult, SplitShardRequest, Response> {
    private static SplitShardResultJsonDeser instance;

    @Override
    public SplitShardResult deserialize(SplitShardRequest request, Response response) throws DatahubServiceException {
        SplitShardResult rs;
        block6: {
            if (!response.isOK()) {
                throw JsonErrorParser.getInstance().parse(response);
            }
            rs = new SplitShardResult();
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = null;
            try {
                tree = mapper.readTree(response.getBody());
                JsonNode node = tree.get("NewShards");
                if (node != null && !node.isNull()) {
                    if (node.isArray()) {
                        Iterator it = node.getElements();
                        while (it.hasNext()) {
                            JsonNode shard = (JsonNode)it.next();
                            ShardDesc entry = new ShardDesc();
                            entry.setShardId(shard.get("ShardId").asText());
                            entry.setBeginHashKey(shard.get("BeginHashKey").asText());
                            entry.setEndHashKey(shard.get("EndHashKey").asText());
                            rs.addShard(entry);
                        }
                    }
                    break block6;
                }
                throw new DatahubServiceException("JsonParseError", "NewShards missing in response body:" + response.getBody(), response);
            }
            catch (IOException e) {
                DatahubServiceException ex = new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
                throw ex;
            }
        }
        return rs;
    }

    private SplitShardResultJsonDeser() {
    }

    public static SplitShardResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new SplitShardResultJsonDeser();
        }
        return instance;
    }
}

