/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.DefaultRequest;
import com.aliyun.datahub.common.transport.HttpMethod;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.MergeShardRequest;
import com.aliyun.datahub.model.serialize.Serializer;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class MergeShardRequestJsonSer
implements Serializer<DefaultRequest, MergeShardRequest> {
    private static MergeShardRequestJsonSer instance;

    @Override
    public DefaultRequest serialize(MergeShardRequest request) throws DatahubClientException {
        DefaultRequest req = new DefaultRequest();
        req.setResource("/projects/" + request.getProjectName() + "/topics/" + request.getTopicName() + "/shards");
        req.setHttpMethod(HttpMethod.POST);
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("Action", "merge");
        node.put("ShardId", request.getShardId());
        node.put("AdjacentShardId", request.getAdjacentShardId());
        try {
            req.setBody(mapper.writeValueAsString((Object)node));
        }
        catch (IOException e) {
            throw new DatahubClientException("serialize error", e);
        }
        return req;
    }

    private MergeShardRequestJsonSer() {
    }

    public static MergeShardRequestJsonSer getInstance() {
        if (instance == null) {
            instance = new MergeShardRequestJsonSer();
        }
        return instance;
    }
}

