/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model.serialize;

import com.aliyun.datahub.common.transport.Response;
import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.GetOffsetRequest;
import com.aliyun.datahub.model.GetOffsetResult;
import com.aliyun.datahub.model.OffsetContext;
import com.aliyun.datahub.model.serialize.Deserializer;
import com.aliyun.datahub.model.serialize.JsonErrorParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GetOffsetResultJsonDeser
implements Deserializer<GetOffsetResult, GetOffsetRequest, Response> {
    private static GetOffsetResultJsonDeser instance;

    @Override
    public GetOffsetResult deserialize(GetOffsetRequest request, Response response) throws DatahubServiceException {
        if (!response.isOK()) {
            throw JsonErrorParser.getInstance().parse(response);
        }
        GetOffsetResult rs = new GetOffsetResult();
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = null;
        try {
            tree = mapper.readTree(response.getBody());
        }
        catch (IOException e) {
            throw new DatahubServiceException("JsonParseError", "Parse body failed:" + response.getBody(), response);
        }
        JsonNode offsetsNode = tree.get("Offsets");
        if (!offsetsNode.isObject()) {
            throw new DatahubServiceException("JsonParseError", "invalid offsets node value", response);
        }
        HashMap<String, OffsetContext.Offset> offsets = new HashMap<String, OffsetContext.Offset>();
        HashMap<String, Long> versions = new HashMap<String, Long>();
        Iterator iterator = offsetsNode.getFields();
        while (iterator.hasNext()) {
            Map.Entry offsetNode = (Map.Entry)iterator.next();
            offsets.put((String)offsetNode.getKey(), new OffsetContext.Offset(((JsonNode)offsetNode.getValue()).get("Sequence").asLong(), ((JsonNode)offsetNode.getValue()).get("Timestamp").asLong()));
            versions.put((String)offsetNode.getKey(), ((JsonNode)offsetNode.getValue()).get("Version").asLong());
        }
        rs.setOffsets(offsets);
        rs.setVersions(versions);
        return rs;
    }

    private GetOffsetResultJsonDeser() {
    }

    public static GetOffsetResultJsonDeser getInstance() {
        if (instance == null) {
            instance = new GetOffsetResultJsonDeser();
        }
        return instance;
    }
}

