/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.model.ShardEntry;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class ListShardResult {
    private List<ShardEntry> shards = new ArrayList<ShardEntry>();

    public List<ShardEntry> getShards() {
        return this.shards;
    }

    public void addShard(ShardEntry entry) {
        this.shards.add(entry);
    }

    public String toString() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ArrayNode shards = mapper.createArrayNode();
        for (ShardEntry entry : this.shards) {
            ObjectNode shard = mapper.createObjectNode();
            shard.put("ShardId", entry.getShardId());
            shard.put("State", entry.getState().toString());
            shard.put("ClosedTime", entry.getClosedTime());
            shard.put("BeginHashKey", entry.getBeginHashKey());
            shard.put("EndHashKey", entry.getEndHashKey());
            shard.put("LeftShardId", entry.getLeftShardId());
            shard.put("RightShardId", entry.getRightShardId());
            ArrayNode parents = mapper.createArrayNode();
            for (String parent : entry.getParentShardIds()) {
                parents.add(parent);
            }
            shard.put("ParentShardIds", (JsonNode)parents);
            shards.add((JsonNode)shard);
        }
        return shards.toString();
    }
}

