/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.transport;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClient {
    Logger logger = Logger.getLogger(HttpClient.class);
    public static final int MAX_ROUTE_CONNECTIONS = 200;
    private CloseableHttpClient httpClient;
    private int connectionTimeout = 30000;
    private int soTimeout = 15000;
    private int maxRouteConnections = 200;
    private int totalConn = 200;
    private PoolingHttpClientConnectionManager connManager;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getMaxRouteConnections() {
        return this.maxRouteConnections;
    }

    public void setMaxRouteConnections(int maxRouteConnections) {
        this.maxRouteConnections = maxRouteConnections;
    }

    public int getTotalConn() {
        return this.totalConn;
    }

    public void setTotalConn(int totalConn) {
        this.totalConn = totalConn;
    }

    public void init() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLSocketFactory theSslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        this.connManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)theSslSocketFactory).build());
        this.connManager.setDefaultMaxPerRoute(this.maxRouteConnections);
        this.connManager.setMaxTotal(this.totalConn);
        this.httpClient = HttpClientBuilder.create().disableContentCompression().setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Charset.forName("UTF-8")).build()).setConnectionManager((HttpClientConnectionManager)this.connManager).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setExpectContinueEnabled(false).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.soTimeout).build()).build();
    }

    public void shutdown() {
        if (this.connManager != null) {
            this.connManager.shutdown();
        }
    }

    public HttpResult doPostWithBytes(String url, Map<String, String> headers, byte[] body) {
        HttpPost httppost = null;
        try {
            httppost = new HttpPost(url);
            this.setHeaders((HttpRequestBase)httppost, headers);
            httppost.setEntity((HttpEntity)new ByteArrayEntity(body));
            HttpResultResponseHandler sph = new HttpResultResponseHandler();
            return (HttpResult)this.httpClient.execute((HttpUriRequest)httppost, (ResponseHandler)sph);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (httppost != null) {
                httppost.abort();
            }
            return new HttpResult();
        }
    }

    public HttpResult doPutWithBytes(String url, Map<String, String> headers, byte[] body) {
        HttpPut httpput = null;
        try {
            httpput = new HttpPut(url);
            this.setHeaders((HttpRequestBase)httpput, headers);
            httpput.setEntity((HttpEntity)new ByteArrayEntity(body));
            HttpResultResponseHandler sph = new HttpResultResponseHandler();
            return (HttpResult)this.httpClient.execute((HttpUriRequest)httpput, (ResponseHandler)sph);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (httpput != null) {
                httpput.abort();
            }
            return new HttpResult();
        }
    }

    public HttpResult doGet(String url, Map<String, String> headers) {
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(url);
            this.setHeaders((HttpRequestBase)httpget, headers);
            HttpResultResponseHandler sph = new HttpResultResponseHandler();
            return (HttpResult)this.httpClient.execute((HttpUriRequest)httpget, (ResponseHandler)sph);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (httpget != null) {
                httpget.abort();
            }
            return new HttpResult();
        }
    }

    public HttpResult doDelete(String url, Map<String, String> headers) {
        HttpDelete httpdelete = null;
        try {
            httpdelete = new HttpDelete(url);
            this.setHeaders((HttpRequestBase)httpdelete, headers);
            HttpResultResponseHandler sph = new HttpResultResponseHandler();
            return (HttpResult)this.httpClient.execute((HttpUriRequest)httpdelete, (ResponseHandler)sph);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (httpdelete != null) {
                httpdelete.abort();
            }
            return new HttpResult();
        }
    }

    public HttpResult doHead(String url, Map<String, String> headers) {
        HttpHead httphead = null;
        try {
            httphead = new HttpHead(url);
            this.setHeaders((HttpRequestBase)httphead, headers);
            HttpResultResponseHandler sph = new HttpResultResponseHandler();
            return (HttpResult)this.httpClient.execute((HttpUriRequest)httphead, (ResponseHandler)sph);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (httphead != null) {
                httphead.abort();
            }
            return new HttpResult();
        }
    }

    private void setHeaders(HttpRequestBase http, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey().equals("Content-Length")) continue;
                http.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public class HttpResult {
        private byte[] body;
        private Map<String, String> header;
        private int code;

        public byte[] getBody() {
            return this.body;
        }

        public void setBody(byte[] body) {
            this.body = body;
        }

        public Map<String, String> getHeader() {
            return this.header;
        }

        public void setHeader(Map<String, String> header) {
            this.header = header;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }
    }

    class HttpResultResponseHandler
    implements ResponseHandler<HttpResult> {
        HttpResultResponseHandler() {
        }

        public HttpResult handleResponse(HttpResponse response) throws IOException {
            HttpResult result = new HttpResult();
            HttpEntity entity = response.getEntity();
            Object[] headers = response.getAllHeaders();
            if (ArrayUtils.isNotEmpty((Object[])headers)) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                for (Object h : headers) {
                    headerMap.put(h.getName(), h.getValue());
                }
                result.setHeader(headerMap);
            }
            if (entity != null) {
                byte[] res = EntityUtils.toByteArray((HttpEntity)entity);
                result.setBody(res);
            }
            result.setCode(response.getStatusLine().getStatusCode());
            return result;
        }
    }
}

