/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub;

import com.aliyun.datahub.auth.Account;
import com.aliyun.datahub.common.transport.ApacheClientTransport;
import com.aliyun.datahub.model.compress.CompressionFormat;
import com.aliyun.datahub.rest.RestClient;
import java.net.URI;
import java.net.URISyntaxException;

public class DatahubConfiguration {
    public static int DEFAULT_SOCKET_CONNECT_TIMEOUT = 180;
    public static int DEFAULT_SOCKET_TIMEOUT = 300;
    public static int DEFAULT_TOTAL_CONNECTION_COUNT = 1000;
    public static int DEFAULT_CONNECTION_COUNT_PER_ENDPOINT = 5;
    private Account account;
    private String endpoint;
    private String userAgent = "DATAHUB-SDK-JAVA";
    private int socketConnectTimeout = DEFAULT_SOCKET_CONNECT_TIMEOUT;
    private int socketTimeout = DEFAULT_SOCKET_TIMEOUT;
    private int totalConnections = DEFAULT_TOTAL_CONNECTION_COUNT;
    private int connectionsPerEndpoint = DEFAULT_CONNECTION_COUNT_PER_ENDPOINT;
    private boolean ignoreCerts = true;
    private CompressionFormat compressionFormat = null;

    public DatahubConfiguration(Account account, String endpoint) {
        this.account = account;
        this.setEndpoint(endpoint);
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setEndpoint(String endpoint) {
        try {
            URI uri = new URI(endpoint);
            this.endpoint = uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getEndpoint(String project) {
        return this.endpoint;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public void setSocketConnectTimeout(int timeout) {
        this.socketConnectTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public boolean isIgnoreCerts() {
        return this.ignoreCerts;
    }

    public void setIgnoreCerts(boolean ignoreCerts) {
        this.ignoreCerts = ignoreCerts;
    }

    public void setCompressionFormat(CompressionFormat compressionFormat) {
        this.compressionFormat = compressionFormat;
    }

    public int getTotalConnections() {
        return this.totalConnections;
    }

    public void setTotalConnections(int totalConnections) {
        this.totalConnections = totalConnections;
    }

    public int getConnectionsPerEndpoint() {
        return this.connectionsPerEndpoint;
    }

    public void setConnectionsPerEndpoint(int connectionsPerEndpoint) {
        this.connectionsPerEndpoint = connectionsPerEndpoint;
    }

    public CompressionFormat getCompressionFormat() {
        return this.compressionFormat;
    }

    public RestClient newRestClient() {
        RestClient client = new RestClient(new ApacheClientTransport(this), this.compressionFormat);
        client.setAccount(this.account);
        client.setEndpoint(this.endpoint);
        client.setUserAgent(this.userAgent);
        client.setReadTimeout(this.getSocketTimeout());
        client.setConnectTimeout(this.getSocketConnectTimeout());
        return client;
    }
}

