/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwEncrypt {
    private static final Logger logger = LoggerFactory.getLogger(GwEncrypt.class);

    private static SecretKey getSecretKey(String password) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        keygen.init(128, random);
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        return new SecretKeySpec(raw, "AES");
    }

    public static String AESEncript(String content, String secret) throws Exception {
        SecretKey key = GwEncrypt.getSecretKey(secret);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] encode = content.getBytes("utf-8");
        byte[] aesByte = cipher.doFinal(encode);
        return GwEncrypt.parseByte2HexStr(Base64.encodeBase64((byte[])aesByte));
    }

    public static String AESDecript(String content, String secret) throws Exception {
        SecretKey key = GwEncrypt.getSecretKey(secret);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] contentByte = Base64.decodeBase64((byte[])GwEncrypt.parseHexStr2Byte(content));
        byte[] decodeByte = cipher.doFinal(contentByte);
        return new String(decodeByte, "utf-8");
    }

    private static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte aBuf : buf) {
            String hex = Integer.toHexString(aBuf & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    private static byte[] parseHexStr2Byte(String hexStr) {
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

