/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.acapi.HttpConfig;
import cn.com.antcloud.api.acapi.StringUtils;
import cn.com.antcloud.api.common.BaseClientRequest;
import cn.com.antcloud.api.common.BaseClientResponse;
import cn.com.antcloud.api.common.ClientException;
import cn.com.antcloud.api.common.GenericTypeResolver;
import cn.com.antcloud.api.common.GwSigns;
import cn.com.antcloud.api.common.SDKConstants;
import cn.com.antcloud.api.common.SDKUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGwClient<REQ extends BaseClientRequest, RES extends BaseClientResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BaseGwClient.class);
    private final String endpoint;
    private final String accessKey;
    private final String accessSecret;
    private final boolean checkSign;
    private final boolean enableAutoRetry;
    private final int autoRetryLimit;
    protected AntCloudHttpClient httpClient;
    protected String securityToken;

    public BaseGwClient(String endpoint, String accessKey, String accessSecret, boolean checkSign, boolean enableAutoRetry, int autoRetryLimit, AntCloudHttpClient httpClient, String securityToken) {
        SDKUtils.checkNotNull(endpoint);
        SDKUtils.checkNotNull(accessKey);
        SDKUtils.checkNotNull(accessSecret);
        this.endpoint = endpoint;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.checkSign = checkSign;
        this.enableAutoRetry = enableAutoRetry;
        this.autoRetryLimit = autoRetryLimit;
        this.httpClient = httpClient;
        this.securityToken = securityToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getAccessSecret() {
        return this.accessSecret;
    }

    public boolean isCheckSign() {
        return this.checkSign;
    }

    protected HttpUriRequest buildRequest(String endpoint, Map<String, String> request) throws UnsupportedEncodingException {
        URI uri;
        try {
            URIBuilder builder = new URIBuilder(endpoint);
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new ClientException("PARASE_URL_ERROR", e);
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String key : request.keySet()) {
            nameValuePairs.add(new BasicNameValuePair(key, request.get(key)));
        }
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        return httpPost;
    }

    public RES execute(REQ request) throws InterruptedException {
        SDKUtils.checkNotNull(request);
        SDKUtils.checkNotNull(((BaseClientRequest)request).getMethod(), "method cannot be null");
        SDKUtils.checkNotNull(((BaseClientRequest)request).getVersion(), "version cannot be null");
        this.prepareParameters(request);
        return this.sendRequest(request);
    }

    private RES sendRequest(REQ request) throws InterruptedException {
        int retried = 0;
        try {
            JSONObject wholeJson;
            String responseString;
            while (true) {
                HttpUriRequest httpUriRequest = this.buildRequest(this.endpoint, ((BaseClientRequest)request).getParameters());
                HttpResponse httpResponse = this.httpClient.invoke(httpUriRequest);
                responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charset.forName("UTF-8"));
                try {
                    wholeJson = JSON.parseObject((String)responseString);
                }
                catch (Throwable e) {
                    logger.error("error when parse response as json, response = {}", (Object)responseString);
                    if (this.enableAutoRetry && retried < this.autoRetryLimit) {
                        logger.error("retry send request, retried count = {}", (Object)(++retried));
                        continue;
                    }
                    throw new ClientException("RESPONSE_FORMAT_ERROR", e);
                }
                break;
            }
            if (wholeJson == null) {
                logger.error(responseString);
                throw new ClientException("TRANSPORT_ERROR", "Unexpected gateway response: " + responseString);
            }
            JSONObject responseNode = wholeJson.getJSONObject("response");
            if (responseNode == null) {
                logger.error(responseString);
                throw new ClientException("TRANSPORT_ERROR", "Unexpected gateway response: " + responseString);
            }
            RES response = this.newResponse();
            ((BaseClientResponse)response).setData(responseNode);
            if (((BaseClientResponse)response).isSuccess() && this.checkSign) {
                String calculatedSign;
                String sign = wholeJson.getString("sign");
                String stringToSign = GwSigns.extractStringToSign(responseString);
                try {
                    calculatedSign = GwSigns.sign(stringToSign, ((BaseClientRequest)request).getParameter("sign_type"), this.accessSecret, SDKConstants.SIGN_CHARSET);
                }
                catch (Exception e) {
                    throw new ClientException("INVALID_RESPONSE_SIGNATURE", "Invalid signature in response");
                }
                if (!calculatedSign.equals(sign)) {
                    throw new ClientException("INVALID_RESPONSE_SIGNATURE", "Invalid signature in response");
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new ClientException("TRANSPORT_ERROR", e);
        }
    }

    protected RES newResponse() {
        Class clazz = GenericTypeResolver.resolveTypeArguments(this.getClass(), BaseGwClient.class)[1];
        try {
            return (RES)((BaseClientResponse)clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create response");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create response");
        }
    }

    private void putParameterIfAbsent(REQ request, String key, String value) {
        if (((BaseClientRequest)request).getParameter(key) == null) {
            ((BaseClientRequest)request).putParameter(key, value);
        }
    }

    private void prepareParameters(REQ request) {
        ((BaseClientRequest)request).putParameter("access_key", this.accessKey);
        this.putParameterIfAbsent(request, "sign_type", "HmacSHA1");
        this.putParameterIfAbsent(request, "req_msg_id", SDKUtils.generateReqMsgId());
        this.putParameterIfAbsent(request, "req_time", SDKUtils.formatDate(new Date()));
        String signType = ((BaseClientRequest)request).getParameter("sign_type");
        if (!signType.equalsIgnoreCase("HmacSHA1") && !signType.equalsIgnoreCase("HmacSHA256")) {
            throw new ClientException("INVALID_PARAMETER", "wrong sign type");
        }
        if (!StringUtils.isEmpty(this.securityToken)) {
            this.putParameterIfAbsent(request, "security_token", this.securityToken);
        }
        this.putParameterIfAbsent(request, "base_sdk_version", "3.4.0");
        try {
            String sign = GwSigns.sign(((BaseClientRequest)request).getParameters(), ((BaseClientRequest)request).getParameter("sign_type"), this.accessSecret, SDKConstants.SIGN_CHARSET);
            ((BaseClientRequest)request).putParameter("sign", sign);
        }
        catch (Exception e) {
            throw new ClientException("UNKNOWN_ERROR", e);
        }
    }

    protected static class Builder<T, B extends Builder<T, B>> {
        private String endpoint;
        private String accessKey;
        private String accessSecret;
        private boolean checkSign = true;
        private boolean enableAutoRetry = false;
        private int autoRetryLimit = 3;
        private AntCloudHttpClient httpClient;
        private String securityToken;

        protected Builder() {
        }

        public T build() {
            Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            if (this.httpClient == null) {
                HttpConfig httpConfig = new HttpConfig();
                this.httpClient = new AntCloudHttpClient(httpConfig);
            }
            try {
                Constructor ctor = clazz.getDeclaredConstructor(String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, AntCloudHttpClient.class, String.class);
                ctor.setAccessible(true);
                return ctor.newInstance(this.endpoint, this.accessKey, this.accessSecret, this.checkSign, this.enableAutoRetry, this.autoRetryLimit, this.httpClient, this.securityToken);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public B setHttpClient(AntCloudHttpClient httpClient) {
            this.httpClient = httpClient;
            return (B)this;
        }

        public B setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return (B)this;
        }

        public B setAccess(String accessKey, String accessSecret) {
            this.accessKey = accessKey.trim();
            this.accessSecret = accessSecret.trim();
            return (B)this;
        }

        public B setCheckSign(boolean checkSign) {
            this.checkSign = checkSign;
            return (B)this;
        }

        public B setEnableAutoRetry(boolean enableAutoRetry) {
            this.enableAutoRetry = enableAutoRetry;
            return (B)this;
        }

        public B setAutoRetryLimit(int autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
            return (B)this;
        }

        public B setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
            return (B)this;
        }
    }
}

