/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.rest;

public final class RestHeaders {
    public static final String ACCESS_KEY = "X-AntCloud-Access-Key";
    public static final String SIGN = "X-AntCloud-Sign";
    public static final String SIGN_TYPE = "X-AntCloud-Sign-Type";
    public static final String CHARSET = "X-AntCloud-Charset";
    public static final String API_VERSION = "X-AntCloud-Api-Version";
    public static final String SDK_VERSION = "X-AntCloud-SDK-Version";
    public static final String REQ_MSG_ID = "X-AntCloud-Req-Msg-Id";
    public static final String REQ_TIME = "X-AntCloud-Req-Time";
    public static final String AUTH_TOKEN = "X-AntCloud-Auth-Token";
    public static final String PRODUCT_INSTANCE_ID = "X-AntCloud-Product-Instance-Id";
    public static final String REGION_NAME = "X-AntCloud-Region-Name";

    /**
     * Http Headers Used In Signature Calculation
     */
    public static final String[] SIGN_HEADERS = {
            ACCESS_KEY,
            SIGN_TYPE,
            CHARSET,
            API_VERSION,
            SDK_VERSION,
            REQ_MSG_ID,
            REQ_TIME,
            AUTH_TOKEN,
            PRODUCT_INSTANCE_ID,
            REGION_NAME,
    };
}
