/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.product;

import cn.com.antcloud.api.common.BaseClientResponse;

public final class AntCloudProdClientResponse extends BaseClientResponse {

    @Deprecated
    public static AntCloudProdClientResponse success() {
        return success(new Object());
    }

    @Deprecated
    public static AntCloudProdClientResponse success(Object o) {
        return BaseClientResponse.success(new AntCloudProdClientResponse(), o);
    }

    @Deprecated
    public static AntCloudProdClientResponse error(String subCode, String subMsg) {
        return BaseClientResponse.error(new AntCloudProdClientResponse(), subCode, subMsg);
    }

    public static AntCloudProdClientResponse success(AntCloudProdClientRequest request) {
        return success(request, new Object());
    }

    public static AntCloudProdClientResponse success(AntCloudProdClientRequest request, Object o) {
        return BaseClientResponse.success(new AntCloudProdClientResponse(), request, o);
    }

    public static AntCloudProdClientResponse error(AntCloudProdClientRequest request,
                                                   String resultCode, String resultMsg) {
        return BaseClientResponse.error(new AntCloudProdClientResponse(), request, resultCode,
            resultMsg);
    }
}
