/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import java.nio.charset.Charset;

public class SDKConstants {

    public static final String BASE_SDK_VERSION_VALUE = "3.4.0";
    public static final String  DEFAULT_CHARSET   = "UTF-8";
    public static final Charset SIGN_CHARSET      = Charset.forName("UTF-8");
    public static final String  DEFAULT_SIGN_TYPE = "HmacSHA1";
    public static final String  SIGN_TYPE_SHA256 = "HmacSHA256";
    public static final String  BASE64URL         = "antcloud-base64://";

    public static class ParamKeys {
        public static final String RESPONSE               = "response";
        public static final String REQ_MSG_ID             = "req_msg_id";
        public static final String RESULT_CODE            = "result_code";
        public static final String RESULT_MSG             = "result_msg";
        public static final String RESULT_MSG_PLACEHOLDER = "result_msg_placeholder";
        public static final String RESULT_MSG_ARGS        = "result_msg_args";
        public static final String SIGN_TYPE              = "sign_type";
        public static final String SIGN                   = "sign";
        public static final String REQ_TIME               = "req_time";
        public static final String BASE_SDK_VERSION       = "base_sdk_version";
        public static final String METHOD                 = "method";
        public static final String VERSION                = "version";
        public static final String ACCESS_KEY             = "access_key";
        public static final String SECURITY_TOKEN         = "security_token";
        public static final String PRODUCT_INSTANCE_ID    = "product_instance_id";
        public static final String REGION_NAME            = "region_name";
        public static final String INVOKER_USER           = "invoker.user";
        public static final String INTERNAL_API           = "internal_api";
    }

    public static class ResultCodes {
        public static final String OK                = "OK";
        public static final String MISSING_PARAMETER = "MISSING_PARAMETER";
        public static final String INVALID_PARAMETER = "INVALID_PARAMETER";
        public static final String TRANSPORT_ERROR   = "TRANSPORT_ERROR";
        public static final String PARASE_URL_ERROR   = "PARASE_URL_ERROR";
        public static final String RESPONSE_FORMAT_ERROR   = "RESPONSE_FORMAT_ERROR";
        public static final String BAD_SIGNATURE     = "INVALID_RESPONSE_SIGNATURE";
        public static final String UNKNOWN_ERROR     = "UNKNOWN_ERROR";
        public static final String ACCESS_DENIED     = "ACCESS_DENIED";
        public static final String METHOD_NOT_FOUND  = "METHOD_NOT_FOUND";
    }

    public static class ResultMsgPlaceholders {
        // The system providing the API behaves unexpectedly
        public static final String PROVIDER_UNKNOWN_ERROR = "PROVIDER_UNKNOWN_ERROR";
    }

}
