/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import java.util.*;

public final class GwRestSignUtils {

    private static final String LINE_DELIMITER   = "\n";
    private static final String HEADER_DELIMITER = ":";
    private static final String DEFAULT_STRING   = "";
    private static final String URL_DELIMITER    = "/";

    @SuppressWarnings("Duplicates")
    public static String getStringToSign(String uri, String httpMethod,
                                         Map<String, String> signHeaders,
                                         Map<String, String> queryParams, String rawPostJsonStr) {
        StringBuilder sb = new StringBuilder();

        // uri
        // ~~ uri需要为标准格式，即开头带/，末尾不带/，比如/sofa/mq/msgtype
        if (!uri.startsWith(URL_DELIMITER)) {
            uri = URL_DELIMITER + uri;
        }
        if (uri.endsWith(URL_DELIMITER)) {
            uri = uri.substring(0, uri.length() - 1);
        }
        sb.append(uri).append(LINE_DELIMITER);

        // http method
        sb.append(httpMethod).append(LINE_DELIMITER);

        // query string
        if (queryParams == null || queryParams.isEmpty()) {
            sb.append(LINE_DELIMITER);
        } else {
            List<String> keys = new ArrayList<String>(queryParams.keySet());
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); i++) {
                String key = keys.get(i);
                if (i != 0) {
                    sb.append("&");
                }
                sb.append(GwSigns.urlEncode(key));
                sb.append("=");
                sb.append(GwSigns.urlEncode(queryParams.get(key)));
            }
            sb.append(LINE_DELIMITER);
        }

        // json request body
        if (rawPostJsonStr == null) {
            rawPostJsonStr = DEFAULT_STRING;
        }
        sb.append(rawPostJsonStr).append(LINE_DELIMITER);

        // headers
        TreeMap<String, String> sortedSignHeaders = new TreeMap<String, String>(signHeaders);
        for (Map.Entry<String, String> entry : sortedSignHeaders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key != null && value != null) {
                sb.append(key.toLowerCase());
                sb.append(HEADER_DELIMITER);
                sb.append(value);
                sb.append(LINE_DELIMITER);
            }
        }

        // remove last line delimiter
        String stringToSign = sb.toString();
        stringToSign = stringToSign.substring(0, stringToSign.length() - LINE_DELIMITER.length());

        return stringToSign;
    }
}
