/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.antcloud.rest;

import cn.com.antcloud.api.common.BaseClientRequest;
import cn.com.antcloud.api.common.GwSignType;
import cn.com.antcloud.api.common.SDKUtils;
import cn.com.antcloud.api.rest.RestHeaders;
import cn.com.antcloud.api.rest.RestHttpMethod;

import java.util.HashMap;
import java.util.Map;

import static cn.com.antcloud.api.rest.RestHeaders.SIGN_HEADERS;


public class AntCloudRestClientRequest extends BaseClientRequest {

    private String urlPath;
    private RestHttpMethod httpMethod;
    private Map<String, String> headers;
    private Map<String, String> queryParams;
    private String postBody;

    public AntCloudRestClientRequest() {
        this.headers = new HashMap<String, String>();
        this.queryParams = new HashMap<String, String>();
    }

    public String getUrlPath() {
        return urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public RestHttpMethod getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(RestHttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryParams() {
        return queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public String getPostBody() {
        return postBody;
    }

    public void setPostBody(String postBody) {
        this.postBody = postBody;
    }

    public void putHeader(String key, String value) {
        SDKUtils.checkNotNull(key);
        headers.put(key, value);
    }

    public String getHeaderValue(String key) {
        return headers.get(key);
    }

    public void putQueryParam(String key, String value) {
        SDKUtils.checkNotNull(key);
        queryParams.put(key, value);
    }

    public void setAuthToken(String authToken) {
        headers.put(RestHeaders.AUTH_TOKEN, authToken);
    }

    public void setProductInstanceId(String productInstanceId) {
        headers.put(RestHeaders.PRODUCT_INSTANCE_ID, productInstanceId);
    }

    public String getProductInstanceId() {
        return headers.get(RestHeaders.PRODUCT_INSTANCE_ID);
    }

    public void setRegionName(String regionName) {
        headers.put(RestHeaders.REGION_NAME, regionName);
    }

    public String getRegionName() {
        return headers.get(RestHeaders.REGION_NAME);
    }

    public void setApiVersion(String apiVersion) {
        headers.put(RestHeaders.API_VERSION, apiVersion);
    }

    public String getApiVersion() {
        return headers.get(RestHeaders.API_VERSION);
    }

    public Map<String, String> getSignHeaders() {
        Map<String, String> signHeaders = new HashMap<String, String>();
        for (String signHeader : SIGN_HEADERS) {
            signHeaders.put(signHeader, headers.get(signHeader));
        }
        return signHeaders;
    }

    public void setSignType(GwSignType gwSignType) {
        headers.put(RestHeaders.SIGN_TYPE, gwSignType.name());
    }
}
