/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.antcloud;

import cn.com.antcloud.api.common.BaseClientResponse;

public final class AntCloudClientResponse extends BaseClientResponse {

    @Deprecated
    public static AntCloudClientResponse success() {
        return success(new Object());
    }

    @Deprecated
    public static AntCloudClientResponse success(Object o) {
        return BaseClientResponse.success(new AntCloudClientResponse(), o);
    }

    @Deprecated
    public static AntCloudClientResponse error(String resultCode, String resultMsg) {
        return BaseClientResponse.error(new AntCloudClientResponse(), resultCode, resultMsg);
    }

    public static AntCloudClientResponse success(AntCloudClientRequest request) {
        return success(request, new Object());
    }

    public static AntCloudClientResponse success(AntCloudClientRequest request, Object o) {
        return BaseClientResponse.success(new AntCloudClientResponse(), request, o);
    }

    public static AntCloudClientResponse error(AntCloudClientRequest request, String resultCode,
                                               String resultMsg) {
        return BaseClientResponse.error(new AntCloudClientResponse(), request, resultCode,
            resultMsg);
    }

}
