/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.antcloud;

import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.common.BaseGwClient;

public class AntCloudClient extends BaseGwClient<AntCloudClientRequest, AntCloudClientResponse> {

    private AntCloudClient(String endpoint, String accessKey, String accessSecret,
                           boolean checkSign, boolean enableAutoRetry, int autoRetryLimit,
                           AntCloudHttpClient client, String securityToken) {
        super(endpoint, accessKey, accessSecret, checkSign, enableAutoRetry, autoRetryLimit, client, securityToken);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public AntCloudClientResponse execute(AntCloudClientRequest request) throws InterruptedException {
        return super.execute(request);
    }

    public <T extends AntCloudResponse> T execute(AntCloudRequest<T> request) throws InterruptedException {
        AntCloudClientRequest clientRequest = new AntCloudClientRequest();
        clientRequest.putParametersFromObject(request);
        AntCloudClientResponse clientResponse = execute(clientRequest);

        T response = clientResponse.getData(request.responseClass());
        response.setResultCode(clientResponse.getResultCode());
        response.setResultMsg(clientResponse.getResultMsg());
        response.setReqMsgId(clientResponse.getReqMsgId());

        return response;
    }

    public static class Builder extends BaseGwClient.Builder<AntCloudClient, Builder> {
    }
}
