/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.acapi;

public abstract class Constants {

    /**
     * TOP默认时间格式
     **/
    public static final String DATE_TIME_FORMAT          = "yyyy-MM-dd HH:mm:ss";

    /**
     * TOP Date默认时区
     **/
    public static final String DATE_TIMEZONE             = "GMT+8";

    /**
     * UTF-8字符集
     **/
    public static final String CHARSET_UTF8              = "UTF-8";

    /**
     * GBK字符集
     **/
    public static final String CHARSET_GBK               = "GBK";

    /**
     * TOP JSON 应格式
     */
    public static final String FORMAT_JSON               = "json";
    /**
     * TOP XML 应格式
     */
    public static final String FORMAT_XML                = "xml";

    /**
     * MD5签名方式
     */
    public static final String SIGN_METHOD_MD5           = "md5";
    /**
     * HMAC签名方式
     */
    public static final String SIGNATURE_METHOD_DEFAULT  = "HMAC-SHA1";

    /**
     * 签名算法版本
     */
    public static final String SIGNATURE_VERSION_DEFAULT = "1.0";

    /**
     * TQL分隔符
     */
    public static final String TQL_SEPERATOR             = "top_tql_seperator";

    /**
     * SDK版本号
     */
    public static final String SDK_VERSION               = "antCloud-sdk-java-20150516";

    /**
     * 返回的错误码
     */
    public static final String ERROR_RESPONSE            = "error_response";
    public static final String ERROR_CODE                = "code";
    public static final String ERROR_MSG                 = "msg";
    public static final String ERROR_SUB_CODE            = "sub_code";
    public static final String ERROR_SUB_MSG             = "sub_msg";

    public static final String SIGNATURE                 = "signature";

    public static final String METHOD                    = "method";

    public static final String VERSION                   = "version";

    public static final String FORMAT                    = "format";

    public static final String ACCESS_KEY                = "accessKey";

    public static final String ACCESS_SECRET             = "accessSecret";

    public static final String TIMESTAMP                 = "timestamp";

    public static final String DATE_FORMAT_ISO8601       = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static final String REQUEST_ID                = "requestId";

    public static final String SIGNATURE_TYPE            = "signatureType";

    public static final String SIGNATURE_VERSION         = "SignatureVersion";

    public static final String TENANT                    = "tenant";

    public static final String CUSTOMER                  = "customer";

    public static final String NONCE                     = "nonce";

}
