/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api;

import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.acapi.HttpConfig;
import cn.com.antcloud.api.acapi.STSConfig;

public class AntFinTechProfile {

    /**
     * access key
     */
    private String accessKey;

    /**
     * access secret
     */
    private String accessSecret;

    /**
     * 基础URL，例如：https://apigw.cloud.alipay.com
     */
    private String baseUrl;

    /**
     * 超时时间
     */
    private int timeOutInMillis;

    /**
     * 是否开启自动重试
     */
    private boolean enableAutoRetry = false;

    /**
     * 自动重试上限
     */
    private int autoRetryLimit = 3;

    /**
     * http 配置
     */
    private HttpConfig httpConfig = new HttpConfig();

    /**
     * STS 配置
     */
    private STSConfig stsConfig = new STSConfig();

    private AntCloudHttpClient httpClient;

    private boolean checkSign = true;

    private AntFinTechProfile(){};

    public synchronized static AntFinTechProfile getProfile(String accessKey, String accessSecret){
        AntFinTechProfile profile = new AntFinTechProfile();
        profile.setAccessKey(accessKey);
        profile.setAccessSecret(accessSecret);
        profile.setBaseUrl(DefaultValues.DEFAULT_BASE_URL);
        profile.setTimeOutInMillis(DefaultValues.DEFAULT_TIMEOUT);
        return profile;
    }

    public synchronized static AntFinTechProfile getProfile(String baseUrl, String accessKey, String accessSecret){
        AntFinTechProfile profile = new AntFinTechProfile();
        profile.setAccessKey(accessKey);
        profile.setAccessSecret(accessSecret);
        profile.setBaseUrl(baseUrl);
        profile.setTimeOutInMillis(DefaultValues.DEFAULT_TIMEOUT);
        return profile;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = new AntCloudHttpClient(httpConfig);
    }

    public HttpConfig getHttpConfig() {
        return httpConfig;
    }

    public AntCloudHttpClient getHttpClient() {
        return httpClient;
    }

    public void setHttpClient(AntCloudHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public STSConfig getStsConfig() {
        return stsConfig;
    }

    public void setStsConfig(STSConfig stsConfig) {
        this.stsConfig = stsConfig;
    }

    public void enableAutoRetry(int limit){
        this.enableAutoRetry = true;
        this.autoRetryLimit = limit;
    }

    public void disableAutoRetry(){
        this.enableAutoRetry = false;
    }

    public boolean isEnableAutoRetry() {
        return enableAutoRetry;
    }

    public int getAutoRetryLimit() {
        return autoRetryLimit;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public void setTimeOutInMillis(int timeOutInMillis) {
        this.timeOutInMillis = timeOutInMillis;
    }

    public void setCheckSign(boolean checkSign) {
        this.checkSign = checkSign;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public String getAccessSecret() {
        return accessSecret;
    }

    public int getTimeOutInMillis() {
        return timeOutInMillis;
    }

    public boolean isCheckSign() {
        return checkSign;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        if (!baseUrl.endsWith("/")){
            this.baseUrl = baseUrl + "/";
        }else{
            this.baseUrl = baseUrl;
        }
    }
}
