/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.util.Assert;

public class StreamsBuilderFactoryBean
extends AbstractFactoryBean<StreamsBuilder>
implements SmartLifecycle {
    private static final int DEFAULT_CLOSE_TIMEOUT = 10;
    private final StreamsConfig streamsConfig;
    private KafkaStreams kafkaStreams;
    private KafkaClientSupplier clientSupplier = new DefaultKafkaClientSupplier();
    private boolean autoStartup = true;
    private int phase = Integer.MIN_VALUE;
    private KafkaStreams.StateListener stateListener;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private int closeTimeout = 10;
    private volatile boolean running;

    public StreamsBuilderFactoryBean(StreamsConfig streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)"'streamsConfig' must not be null");
        this.streamsConfig = streamsConfig;
    }

    public StreamsBuilderFactoryBean(Map<String, Object> streamsConfig) {
        Assert.notNull(streamsConfig, (String)"'streamsConfig' must not be null");
        this.streamsConfig = new StreamsConfig(streamsConfig);
    }

    public void setClientSupplier(KafkaClientSupplier clientSupplier) {
        Assert.notNull((Object)clientSupplier, (String)"'clientSupplier' must not be null");
        this.clientSupplier = clientSupplier;
    }

    public void setStateListener(KafkaStreams.StateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public Class<?> getObjectType() {
        return StreamsBuilder.class;
    }

    protected StreamsBuilder createInstance() throws Exception {
        return new StreamsBuilder();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                this.kafkaStreams = new KafkaStreams(((StreamsBuilder)this.getObject()).build(), this.streamsConfig, this.clientSupplier);
                this.kafkaStreams.setStateListener(this.stateListener);
                this.kafkaStreams.setUncaughtExceptionHandler(this.exceptionHandler);
                this.kafkaStreams.start();
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                if (this.kafkaStreams != null) {
                    this.kafkaStreams.close((long)this.closeTimeout, TimeUnit.SECONDS);
                    this.kafkaStreams.cleanUp();
                    this.kafkaStreams = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }
}

