/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.propagation.CurrentTraceContext;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.log.SleuthSlf4jProperties;
import org.springframework.cloud.sleuth.log.Slf4jScopeDecorator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@Deprecated
public class SleuthLogAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MDC.class})
    @EnableConfigurationProperties(value={SleuthSlf4jProperties.class})
    public static class Slf4jConfiguration {
        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.log.slf4j.enabled"}, matchIfMissing=true)
        static CurrentTraceContext.ScopeDecorator slf4jSpanDecorator(SleuthProperties sleuthProperties, SleuthSlf4jProperties sleuthSlf4jProperties) {
            return new Slf4jScopeDecorator(sleuthProperties, sleuthSlf4jProperties);
        }
    }
}

