/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class RetryableFeignBlockingLoadBalancerClient
implements Client {
    private static final Log LOG = LogFactory.getLog(FeignBlockingLoadBalancerClient.class);
    private final Client delegate;
    private final BlockingLoadBalancerClient loadBalancerClient;
    private final LoadBalancedRetryFactory loadBalancedRetryFactory;

    public RetryableFeignBlockingLoadBalancerClient(Client delegate, BlockingLoadBalancerClient loadBalancerClient, LoadBalancedRetryFactory loadBalancedRetryFactory) {
        this.delegate = delegate;
        this.loadBalancerClient = loadBalancerClient;
        this.loadBalancedRetryFactory = loadBalancedRetryFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        URI originalUri = URI.create(request.url());
        String serviceId = originalUri.getHost();
        LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryFactory.createRetryPolicy(serviceId, (ServiceInstanceChooser)this.loadBalancerClient);
        RetryTemplate retryTemplate = this.buildRetryTemplate(serviceId, request, retryPolicy);
        return (Response)retryTemplate.execute(context -> {
            ServiceInstance serviceInstance;
            Request feignRequest = null;
            if (context instanceof LoadBalancedRetryContext && (serviceInstance = ((LoadBalancedRetryContext)context).getServiceInstance()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Using service instance from LoadBalancedRetryContext: %s", serviceInstance));
                }
                String reconstructedUrl = this.loadBalancerClient.reconstructURI(serviceInstance, originalUri).toString();
                feignRequest = this.buildRequest(request, reconstructedUrl);
            }
            if (feignRequest == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Service instance was not resolved, executing the original request");
                }
                feignRequest = request;
            }
            Response response = this.delegate.execute(feignRequest, options);
            int responseStatus = response.status();
            if (retryPolicy != null && retryPolicy.retryableStatusCode(responseStatus)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Retrying on status code: %d", responseStatus));
                }
                response.close();
                throw new RetryableStatusCodeException(serviceId, responseStatus, (Object)response, URI.create(request.url()));
            }
            return response;
        }, (RecoveryCallback)new LoadBalancedRecoveryCallback<Response, Response>(){

            protected Response createResponse(Response response, URI uri) {
                return response;
            }
        });
    }

    protected Request buildRequest(Request request, String reconstructedUrl) {
        return Request.create((Request.HttpMethod)request.httpMethod(), (String)reconstructedUrl, (Map)request.headers(), (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
    }

    private RetryTemplate buildRetryTemplate(String serviceId, Request request, LoadBalancedRetryPolicy retryPolicy) {
        RetryTemplate retryTemplate = new RetryTemplate();
        BackOffPolicy backOffPolicy = this.loadBalancedRetryFactory.createBackOffPolicy(serviceId);
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryFactory.createRetryListeners(serviceId);
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        retryTemplate.setRetryPolicy((RetryPolicy)(retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(this.toHttpRequest(request), retryPolicy, (ServiceInstanceChooser)this.loadBalancerClient, serviceId)));
        return retryTemplate;
    }

    public Client getDelegate() {
        return this.delegate;
    }

    private HttpRequest toHttpRequest(final Request request) {
        return new HttpRequest(){

            public HttpMethod getMethod() {
                return HttpMethod.resolve((String)request.httpMethod().name());
            }

            public String getMethodValue() {
                return this.getMethod().name();
            }

            public URI getURI() {
                return URI.create(request.url());
            }

            public HttpHeaders getHeaders() {
                HashMap headers = new HashMap();
                Map feignHeaders = request.headers();
                for (String key : feignHeaders.keySet()) {
                    headers.put(key, new ArrayList((Collection)feignHeaders.get(key)));
                }
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll(headers);
                return httpHeaders;
            }
        };
    }
}

