/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;

public class RibbonHttpResponse
extends AbstractClientHttpResponse {
    private HttpResponse response;
    private HttpHeaders httpHeaders;

    public RibbonHttpResponse(HttpResponse response) {
        this.response = response;
        this.httpHeaders = new HttpHeaders();
        List headers = response.getHttpHeaders().getAllHeaders();
        for (Map.Entry header : headers) {
            this.httpHeaders.add((String)header.getKey(), (String)header.getValue());
        }
    }

    public InputStream getBody() throws IOException {
        return this.response.getInputStream();
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getStatus();
    }

    public String getStatusText() throws IOException {
        return HttpStatus.valueOf((int)this.response.getStatus()).name();
    }

    public void close() {
        this.response.close();
    }
}

