/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.apache;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.zuul.context.RequestContext;
import java.io.InputStream;
import java.net.URI;
import org.springframework.cloud.netflix.ribbon.RibbonHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;

public class HttpClientRibbonCommand
extends HystrixCommand<ClientHttpResponse>
implements RibbonCommand {
    private final RibbonLoadBalancingHttpClient client;
    private final String method;
    private final String uri;
    private final MultiValueMap<String, String> headers;
    private final MultiValueMap<String, String> params;
    private final InputStream requestEntity;
    private final Boolean retryable;

    public HttpClientRibbonCommand(RibbonLoadBalancingHttpClient client, String method, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, Boolean retryable) {
        this("default", client, method, uri, headers, params, requestEntity, retryable);
    }

    public HttpClientRibbonCommand(String commandKey, RibbonLoadBalancingHttpClient client, String method, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, Boolean retryable) {
        super(HttpClientRibbonCommand.getSetter(commandKey));
        this.client = client;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
        this.retryable = retryable;
    }

    protected static HystrixCommand.Setter getSetter(String commandKey) {
        String name = "zuul.eureka." + commandKey + ".semaphore.maxSemaphores";
        DynamicIntProperty value = DynamicPropertyFactory.getInstance().getIntProperty(name, 100);
        HystrixCommandProperties.Setter setter = HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(value.get());
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"RibbonCommand")).andCommandKey(HystrixCommandKey.Factory.asKey((String)(commandKey + "RibbonCommand"))).andCommandPropertiesDefaults(setter);
    }

    protected ClientHttpResponse run() throws Exception {
        return this.forward();
    }

    protected ClientHttpResponse forward() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        URI uriInstance = new URI(this.uri);
        RibbonApacheHttpRequest request = new RibbonApacheHttpRequest(this.method, uriInstance, this.retryable, this.headers, this.params, this.requestEntity);
        RibbonApacheHttpResponse response = (RibbonApacheHttpResponse)this.client.executeWithLoadBalancer(request);
        context.set("ribbonResponse", (Object)response);
        if (this.isResponseTimedOut() && response != null) {
            response.close();
        }
        return new RibbonHttpResponse(response);
    }
}

