/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.StringUtils;

public class Route {
    private String id;
    private String fullPath;
    private String path;
    private String location;
    private String prefix;
    private Boolean retryable;
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>();
    private boolean customSensitiveHeaders;

    public Route(String id, String path, String location, String prefix, Boolean retryable, Set<String> ignoredHeaders) {
        this.id = id;
        this.prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        this.path = path;
        this.fullPath = prefix + path;
        this.location = location;
        this.retryable = retryable;
        this.sensitiveHeaders = new LinkedHashSet<String>();
        if (ignoredHeaders != null) {
            this.customSensitiveHeaders = true;
            for (String header : ignoredHeaders) {
                this.sensitiveHeaders.add(header.toLowerCase());
            }
        }
    }

    public boolean isCustomSensitiveHeaders() {
        return this.customSensitiveHeaders;
    }

    public String getId() {
        return this.id;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public Set<String> getSensitiveHeaders() {
        return this.sensitiveHeaders;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public void setSensitiveHeaders(Set<String> sensitiveHeaders) {
        this.sensitiveHeaders = sensitiveHeaders;
    }

    public void setCustomSensitiveHeaders(boolean customSensitiveHeaders) {
        this.customSensitiveHeaders = customSensitiveHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$fullPath = this.getFullPath();
        String other$fullPath = other.getFullPath();
        if (this$fullPath == null ? other$fullPath != null : !this$fullPath.equals(other$fullPath)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Boolean this$retryable = this.getRetryable();
        Boolean other$retryable = other.getRetryable();
        if (this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable)) {
            return false;
        }
        Set<String> this$sensitiveHeaders = this.getSensitiveHeaders();
        Set<String> other$sensitiveHeaders = other.getSensitiveHeaders();
        if (this$sensitiveHeaders == null ? other$sensitiveHeaders != null : !((Object)this$sensitiveHeaders).equals(other$sensitiveHeaders)) {
            return false;
        }
        return this.isCustomSensitiveHeaders() == other.isCustomSensitiveHeaders();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Route;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $fullPath = this.getFullPath();
        result = result * 59 + ($fullPath == null ? 43 : $fullPath.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Boolean $retryable = this.getRetryable();
        result = result * 59 + ($retryable == null ? 43 : ((Object)$retryable).hashCode());
        Set<String> $sensitiveHeaders = this.getSensitiveHeaders();
        result = result * 59 + ($sensitiveHeaders == null ? 43 : ((Object)$sensitiveHeaders).hashCode());
        result = result * 59 + (this.isCustomSensitiveHeaders() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Route(id=" + this.getId() + ", fullPath=" + this.getFullPath() + ", path=" + this.getPath() + ", location=" + this.getLocation() + ", prefix=" + this.getPrefix() + ", retryable=" + this.getRetryable() + ", sensitiveHeaders=" + this.getSensitiveHeaders() + ", customSensitiveHeaders=" + this.isCustomSensitiveHeaders() + ")";
    }
}

