/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.cloud.netflix.zuul.util.RequestUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriTemplate;
import org.springframework.web.util.UriUtils;

public class ProxyRequestHelper {
    private static final Log log = LogFactory.getLog(ProxyRequestHelper.class);
    public static final String IGNORED_HEADERS = "ignoredHeaders";
    private TraceRepository traces;
    private Set<String> ignoredHeaders = new LinkedHashSet<String>();
    private Set<String> sensitiveHeaders = new LinkedHashSet<String>();
    private Set<String> whitelistHosts = new LinkedHashSet<String>();
    private boolean traceRequestBody = true;

    public void setWhitelistHosts(Set<String> whitelistHosts) {
        this.whitelistHosts.addAll(whitelistHosts);
    }

    public void setSensitiveHeaders(Set<String> sensitiveHeaders) {
        this.sensitiveHeaders.addAll(sensitiveHeaders);
    }

    public void setIgnoredHeaders(Set<String> ignoredHeaders) {
        this.ignoredHeaders.addAll(ignoredHeaders);
    }

    public void setTraces(TraceRepository traces) {
        this.traces = traces;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public String buildZuulRequestURI(HttpServletRequest request) {
        RequestContext context = RequestContext.getCurrentContext();
        String uri = request.getRequestURI();
        String contextURI = (String)context.get((Object)"requestURI");
        if (contextURI != null) {
            try {
                uri = UriUtils.encodePath((String)contextURI, (String)"ISO-8859-1");
            }
            catch (Exception e) {
                log.debug((Object)"unable to encode uri path from context, falling back to uri from request", (Throwable)e);
            }
        }
        return uri;
    }

    public MultiValueMap<String, String> buildZuulRequestQueryParams(HttpServletRequest request) {
        Map map = HTTPRequestUtils.getInstance().getQueryParams();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (map == null) {
            return params;
        }
        for (String key : map.keySet()) {
            for (String value : (List)map.get(key)) {
                params.add((Object)key, (Object)value);
            }
        }
        return params;
    }

    public MultiValueMap<String, String> buildZuulRequestHeaders(HttpServletRequest request) {
        RequestContext context = RequestContext.getCurrentContext();
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (!this.isIncludedHeader(name)) continue;
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    headers.add((Object)name, (Object)value);
                }
            }
        }
        Map zuulRequestHeaders = context.getZuulRequestHeaders();
        for (String header : zuulRequestHeaders.keySet()) {
            headers.set((Object)header, zuulRequestHeaders.get(header));
        }
        headers.set((Object)"Accept-Encoding", (Object)"gzip");
        return headers;
    }

    public void setResponse(int status, InputStream entity, MultiValueMap<String, String> headers) throws IOException {
        RequestContext context = RequestContext.getCurrentContext();
        context.setResponseStatusCode(status);
        if (entity != null) {
            context.setResponseDataStream(entity);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                httpHeaders.add((String)header.getKey(), value);
            }
        }
        boolean isOriginResponseGzipped = false;
        if (httpHeaders.containsKey((Object)"Content-Encoding")) {
            List collection = httpHeaders.get((Object)"Content-Encoding");
            for (String header : collection) {
                if (!HTTPRequestUtils.getInstance().isGzipped(header)) continue;
                isOriginResponseGzipped = true;
                break;
            }
        }
        context.setResponseGZipped(isOriginResponseGzipped);
        for (Map.Entry header : headers.entrySet()) {
            String name = (String)header.getKey();
            for (String value : (List)header.getValue()) {
                context.addOriginResponseHeader(name, value);
                if (name.equalsIgnoreCase("Content-Length")) {
                    context.setOriginContentLength(value);
                }
                if (!this.isIncludedHeader(name)) continue;
                context.addZuulResponseHeader(name, value);
            }
        }
    }

    public void addIgnoredHeaders(String ... names) {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (!ctx.containsKey((Object)IGNORED_HEADERS)) {
            ctx.set(IGNORED_HEADERS, new HashSet());
        }
        Set set = (Set)ctx.get((Object)IGNORED_HEADERS);
        for (String name : this.ignoredHeaders) {
            set.add(name.toLowerCase());
        }
        for (String name : names) {
            set.add(name.toLowerCase());
        }
    }

    public boolean isIncludedHeader(String headerName) {
        Object object;
        String name = headerName.toLowerCase();
        RequestContext ctx = RequestContext.getCurrentContext();
        if (ctx.containsKey((Object)IGNORED_HEADERS) && (object = ctx.get((Object)IGNORED_HEADERS)) instanceof Collection && ((Collection)object).contains(name)) {
            return false;
        }
        switch (name) {
            case "host": 
            case "connection": 
            case "content-length": 
            case "content-encoding": 
            case "server": 
            case "transfer-encoding": 
            case "x-application-context": {
                return false;
            }
        }
        return true;
    }

    public Map<String, Object> debug(String verb, String uri, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws IOException {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        if (this.traces != null) {
            RequestContext context = RequestContext.getCurrentContext();
            info.put("method", verb);
            info.put("path", uri);
            info.put("query", this.getQueryString(params));
            info.put("remote", true);
            info.put("proxy", context.get((Object)"proxy"));
            LinkedHashMap trace = new LinkedHashMap();
            LinkedHashMap input = new LinkedHashMap();
            trace.put("request", input);
            info.put("headers", trace);
            for (Map.Entry entry : headers.entrySet()) {
                Collection collection = (Collection)entry.getValue();
                Object value = collection;
                if (collection.size() < 2) {
                    value = collection.isEmpty() ? "" : (String)collection.iterator().next();
                }
                input.put(entry.getKey(), (Collection)value);
            }
            RequestContext ctx = RequestContext.getCurrentContext();
            if (this.shouldDebugBody(ctx) && requestEntity != null) {
                this.debugRequestEntity(info, (InputStream)ctx.getRequest().getInputStream());
            }
            this.traces.add(info);
            return info;
        }
        return info;
    }

    boolean shouldDebugBody(RequestContext ctx) {
        HttpServletRequest request = ctx.getRequest();
        if (!this.traceRequestBody || ctx.isChunkedRequestBody() || RequestUtils.isZuulServletRequest()) {
            return false;
        }
        if (request == null || request.getContentType() == null) {
            return true;
        }
        return !request.getContentType().toLowerCase().contains("multipart");
    }

    public void appendDebug(Map<String, Object> info, int status, MultiValueMap<String, String> headers) {
        if (this.traces != null) {
            Map trace = (Map)info.get("headers");
            LinkedHashMap output = new LinkedHashMap();
            trace.put("response", output);
            for (Map.Entry key : headers.entrySet()) {
                Collection collection = (Collection)key.getValue();
                Object value = collection;
                if (collection.size() < 2) {
                    value = collection.isEmpty() ? "" : (String)collection.iterator().next();
                }
                output.put(key.getKey(), value);
            }
            output.put("status", "" + status);
        }
    }

    private void debugRequestEntity(Map<String, Object> info, InputStream inputStream) throws IOException {
        if (RequestContext.getCurrentContext().isChunkedRequestBody()) {
            info.put("body", "<chunked>");
            return;
        }
        char[] buffer = new char[4096];
        int count = new InputStreamReader(inputStream, Charset.forName("UTF-8")).read(buffer, 0, buffer.length);
        if (count > 0) {
            String entity = new String(buffer).substring(0, count);
            info.put("body", entity.length() < 4096 ? entity : entity + "<truncated>");
        }
    }

    public String getQueryString(MultiValueMap<String, String> params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        HashMap<String, String> singles = new HashMap<String, String>();
        for (String param : params.keySet()) {
            int i = 0;
            for (String value : (List)params.get((Object)param)) {
                query.append("&");
                query.append(param);
                if (!"".equals(value)) {
                    singles.put(param + i, value);
                    query.append("={");
                    query.append(param + i);
                    query.append("}");
                }
                ++i;
            }
        }
        UriTemplate template = new UriTemplate("?" + query.toString().substring(1));
        return template.expand(singles).toString();
    }
}

