/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.ClientRequest;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.springframework.util.MultiValueMap;

public class RibbonApacheHttpRequest
extends ClientRequest
implements Cloneable {
    private final String method;
    private final MultiValueMap<String, String> headers;
    private final MultiValueMap<String, String> params;
    private final InputStream requestEntity;

    public RibbonApacheHttpRequest(String method, URI uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) {
        this.method = method;
        this.uri = uri;
        this.isRetriable = retryable;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
    }

    public HttpUriRequest toRequest(RequestConfig requestConfig) {
        List values;
        RequestBuilder builder = RequestBuilder.create((String)this.method);
        builder.setUri(this.uri);
        for (String name : this.headers.keySet()) {
            values = (List)this.headers.get((Object)name);
            for (String value : values) {
                builder.addHeader(name, value);
            }
        }
        for (String name : this.params.keySet()) {
            values = (List)this.params.get((Object)name);
            for (String value : values) {
                builder.addParameter(name, value);
            }
        }
        if (this.requestEntity != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent(this.requestEntity);
            builder.setEntity((HttpEntity)entity);
        }
        builder.setConfig(requestConfig);
        return builder.build();
    }

    public RibbonApacheHttpRequest withNewUri(URI uri) {
        return new RibbonApacheHttpRequest(this.method, uri, this.isRetriable, this.headers, this.params, this.requestEntity);
    }

    public String getMethod() {
        return this.method;
    }

    public MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getParams() {
        return this.params;
    }

    public InputStream getRequestEntity() {
        return this.requestEntity;
    }
}

