/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.netflix.metrics.MetricsTagProvider;
import org.springframework.cloud.netflix.metrics.RestTemplateUrlTemplateHolder;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;

public class DefaultMetricsTagProvider
implements MetricsTagProvider {
    @Override
    public Map<String, String> clientHttpRequestTags(HttpRequest request, ClientHttpResponse response) {
        String status;
        String urlTemplate = RestTemplateUrlTemplateHolder.getRestTemplateUrlTemplate();
        if (urlTemplate == null) {
            urlTemplate = "none";
        }
        try {
            status = response == null ? "CLIENT_ERROR" : Integer.valueOf(response.getRawStatusCode()).toString();
        }
        catch (IOException e) {
            status = "IO_ERROR";
        }
        String host = request.getURI().getHost();
        String strippedUrlTemplate = urlTemplate.replaceAll("^https?://[^/]+/", "");
        return ImmutableMap.of((Object)"method", (Object)request.getMethod().name(), (Object)"uri", (Object)this.sanitizeUrlTemplate(strippedUrlTemplate), (Object)"status", (Object)status, (Object)"clientName", (Object)(host != null ? host : "none"));
    }

    @Override
    public Map<String, String> httpRequestTags(HttpServletRequest request, HttpServletResponse response, Object handler, String caller) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("method", request.getMethod());
        tags.put("status", Integer.valueOf(response.getStatus()).toString());
        String uri = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (uri == null) {
            uri = request.getPathInfo();
        }
        if (!StringUtils.hasText((String)uri)) {
            uri = "/";
        }
        tags.put("uri", (uri = this.sanitizeUrlTemplate(uri.substring(1))).isEmpty() ? "root" : uri);
        Object exception = request.getAttribute("exception");
        if (exception != null) {
            tags.put("exception", exception.getClass().getSimpleName());
        }
        if (caller != null) {
            tags.put("caller", caller);
        }
        return tags;
    }

    private String sanitizeUrlTemplate(String urlTemplate) {
        String sanitized = urlTemplate.replaceAll("/", "_").replaceAll("[{}]", "-");
        if (!StringUtils.hasText((String)sanitized)) {
            sanitized = "none";
        }
        return sanitized;
    }
}

