/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.security.rsa.crypto.RsaAlgorithm;
import org.springframework.util.ClassUtils;

@ConfigurationProperties(value="encrypt")
public class KeyProperties {
    private String key;
    private boolean failOnError = true;
    private KeyStore keyStore = new KeyStore();
    private Rsa rsa;

    public KeyProperties() {
        if (ClassUtils.isPresent((String)"org.springframework.security.rsa.crypto.RsaAlgorithm", null)) {
            this.rsa = new Rsa();
        }
    }

    public Rsa getRsa() {
        return this.rsa;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public static class KeyStore {
        private Resource location;
        private String password;
        private String alias;
        private String secret;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getSecret() {
            return this.secret == null ? this.password : this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    public static class Rsa {
        private RsaAlgorithm algorithm = RsaAlgorithm.DEFAULT;
        private boolean strong = false;
        private String salt = "deadbeef";

        public RsaAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(RsaAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public boolean isStrong() {
            return this.strong;
        }

        public void setStrong(boolean strong) {
            this.strong = strong;
        }

        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }
    }
}

