/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.transport.TLSConfig;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.consul")
@Validated
public class ConsulProperties {
    @NotNull
    private String host = "localhost";
    private String scheme;
    @NotNull
    private int port = 8500;
    private boolean enabled = true;
    private TLSConfig tls;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public TLSConfig getTls() {
        return this.tls;
    }

    public void setTls(TLSConfig tls) {
        this.tls = tls;
    }

    public String toString() {
        return "ConsulProperties{host='" + this.host + '\'' + ", port=" + this.port + ", scheme=" + this.scheme + ", tls=" + this.tls + ", enabled=" + this.enabled + '}';
    }

    public static class TLSConfig {
        private TLSConfig.KeyStoreInstanceType keyStoreInstanceType;
        private String keyStorePath;
        private String keyStorePassword;
        private String certificatePath;
        private String certificatePassword;

        public TLSConfig() {
        }

        public TLSConfig(TLSConfig.KeyStoreInstanceType keyStoreInstanceType, String keyStorePath, String keyStorePassword, String certificatePath, String certificatePassword) {
            this.keyStoreInstanceType = keyStoreInstanceType;
            this.keyStorePath = keyStorePath;
            this.keyStorePassword = keyStorePassword;
            this.certificatePath = certificatePath;
            this.certificatePassword = certificatePassword;
        }

        public TLSConfig.KeyStoreInstanceType getKeyStoreInstanceType() {
            return this.keyStoreInstanceType;
        }

        public void setKeyStoreInstanceType(TLSConfig.KeyStoreInstanceType keyStoreInstanceType) {
            this.keyStoreInstanceType = keyStoreInstanceType;
        }

        public String getKeyStorePath() {
            return this.keyStorePath;
        }

        public void setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getCertificatePath() {
            return this.certificatePath;
        }

        public void setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
        }

        public String getCertificatePassword() {
            return this.certificatePassword;
        }

        public void setCertificatePassword(String certificatePassword) {
            this.certificatePassword = certificatePassword;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("keyStoreInstanceType", (Object)this.keyStoreInstanceType).append("keyStorePath", (Object)this.keyStorePath).append("keyStorePassword", (Object)this.keyStorePassword).append("certificatePath", (Object)this.certificatePath).append("certificatePassword", (Object)this.certificatePassword).toString();
        }
    }
}

